/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.parser.token.XBToken;
import org.exbin.xbup.core.parser.token.XBTokenType;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

@ParametersAreNonnullByDefault
public abstract class XBAttributeToken
implements XBToken {
    @Nullable
    private static XBZeroAttributeToken cachedZeroToken = null;

    @Nonnull
    public abstract XBAttribute getAttribute();

    public abstract boolean isZero();

    @Override
    @Nonnull
    public XBTokenType getTokenType() {
        return XBTokenType.ATTRIBUTE;
    }

    @Nonnull
    public static XBAttributeToken create(XBAttribute attribute) {
        return new XBAttributeTokenImpl(attribute);
    }

    @Nonnull
    public static XBZeroAttributeToken createZeroToken() {
        if (cachedZeroToken == null) {
            cachedZeroToken = new XBZeroAttributeToken();
        }
        return cachedZeroToken;
    }

    private static class XBZeroAttributeToken
    extends XBAttributeToken {
        XBZeroAttributeToken() {
        }

        @Override
        @Nonnull
        public XBAttribute getAttribute() {
            return new UBNat32();
        }

        @Override
        public boolean isZero() {
            return true;
        }
    }

    @ParametersAreNonnullByDefault
    private static class XBAttributeTokenImpl
    extends XBAttributeToken {
        @Nonnull
        private final XBAttribute attribute;

        private XBAttributeTokenImpl(XBAttribute attribute) {
            this.attribute = attribute;
        }

        @Override
        @Nonnull
        public XBAttribute getAttribute() {
            return this.attribute;
        }

        @Override
        public boolean isZero() {
            return this.attribute.isNaturalZero();
        }
    }
}

