/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.basic.wrapper;

import java.io.IOException;
import java.io.OutputStream;
import org.exbin.xbup.core.stream.FinishableStream;

public class TerminatedDataOutputStreamWrapper
extends OutputStream
implements FinishableStream {
    private final OutputStream stream;
    private int zeroCount = 0;
    private int length = 0;

    public TerminatedDataOutputStreamWrapper(OutputStream stream) throws IOException {
        this.stream = stream;
    }

    @Override
    public void write(int b) throws IOException {
        if (b == 0) {
            this.writeProcessZero();
        } else {
            this.writeFlushZeros();
            this.stream.write(b);
            ++this.length;
        }
    }

    @Override
    public void write(byte[] buffer, int off, int len) throws IOException {
        int pos;
        int processFrom = off;
        for (pos = off; pos < off + len; ++pos) {
            byte b = buffer[off + pos];
            if (b == 0) {
                if (pos > processFrom) {
                    int writeLen = pos - processFrom;
                    this.stream.write(buffer, processFrom, writeLen);
                    this.length += writeLen;
                    processFrom = pos + 1;
                }
                this.writeProcessZero();
                continue;
            }
            this.writeFlushZeros();
        }
        if (processFrom < pos) {
            int writeLen = pos - processFrom;
            this.stream.write(buffer, processFrom, writeLen);
            this.length += writeLen;
        }
    }

    private void writeProcessZero() throws IOException {
        if (this.zeroCount < 254) {
            ++this.zeroCount;
        } else {
            this.writeFlushZeros();
        }
    }

    private void writeFlushZeros() throws IOException {
        if (this.zeroCount > 0) {
            this.stream.write(0);
            this.stream.write(this.zeroCount);
            this.length += 2;
            this.zeroCount = 0;
        }
    }

    @Override
    public long finish() throws IOException {
        this.writeFlushZeros();
        this.stream.write(0);
        this.stream.write(0);
        this.length += 2;
        return this.length;
    }

    @Override
    public long getLength() {
        return this.length;
    }
}

