/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.block.declaration;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.declaration.XBContext;
import org.exbin.xbup.core.block.declaration.XBDeclaration;
import org.exbin.xbup.core.block.declaration.XBTypeConvertor;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.basic.XBTListener;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTokenType;
import org.exbin.xbup.core.parser.token.convert.XBTListenerToToken;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;
import org.exbin.xbup.core.serial.basic.XBReceivingFinished;
import org.exbin.xbup.core.serial.basic.XBTBasicInputReceivingSerialHandler;

@ParametersAreNonnullByDefault
public class XBLevelContext
implements XBTListener,
XBTEventListener {
    private int depthLevel = 0;
    private XBCatalog catalog = null;
    private XBTypeConvertor typeConvertor = null;
    private XBTypeConvertor parentContext = null;
    private XBDeclaration declaration = null;
    private XBTListener declarationBuilderListener = null;

    public XBLevelContext(XBCatalog catalog, int depthLevel) {
        this(catalog, null, depthLevel, true);
    }

    public XBLevelContext(XBCatalog catalog, @Nullable XBTypeConvertor context, int depthLevel) {
        this(catalog, context, depthLevel, true);
    }

    public XBLevelContext(XBCatalog catalog, @Nullable XBTypeConvertor context, int depthLevel, boolean useDeclaration) {
        this.catalog = catalog;
        this.depthLevel = depthLevel;
        this.typeConvertor = context != null ? context : this.declaration;
        if (useDeclaration) {
            this.declaration = new XBDeclaration();
            this.declaration.setHeaderMode(true);
            try {
                this.declaration.serializeRecvFromXB(new XBTBasicInputReceivingSerialHandler(){

                    @Override
                    public void process(XBTListener listener) {
                        XBLevelContext.this.declarationBuilderListener = listener;
                    }
                });
            }
            catch (IOException | XBProcessingException ex) {
                Logger.getLogger(XBLevelContext.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public int getDepthLevel() {
        return this.depthLevel;
    }

    public void setDepthLevel(int depthLevel) {
        this.depthLevel = depthLevel;
    }

    @Nullable
    public XBTypeConvertor getContext() {
        return this.typeConvertor;
    }

    public void setContext(@Nullable XBContext context) {
        this.typeConvertor = context;
    }

    public boolean isDeclarationFinished() {
        return this.declarationBuilderListener == null;
    }

    @Nullable
    public XBTypeConvertor getParentContext() {
        return this.parentContext;
    }

    public void setParentContext(@Nullable XBContext parentContext) {
        this.parentContext = parentContext;
    }

    @Override
    public void beginXBT(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
        this.declarationBuilderListener.beginXBT(terminationMode);
    }

    @Override
    public void typeXBT(XBBlockType blockType) throws XBProcessingException, IOException {
        this.declarationBuilderListener.typeXBT(blockType);
    }

    @Override
    public void attribXBT(XBAttribute attribute) throws XBProcessingException, IOException {
        this.declarationBuilderListener.attribXBT(attribute);
    }

    @Override
    public void dataXBT(InputStream data) throws XBProcessingException, IOException {
        this.declarationBuilderListener.dataXBT(data);
    }

    @Override
    public void endXBT() throws XBProcessingException, IOException {
        this.declarationBuilderListener.endXBT();
        this.verifyDeclarationFinishing();
    }

    @Override
    public void putXBTToken(XBTToken token) throws XBProcessingException, IOException {
        XBTListenerToToken.tokenToListener(token, this.declarationBuilderListener);
        if (token.getTokenType() == XBTTokenType.END) {
            this.verifyDeclarationFinishing();
        }
    }

    private void verifyDeclarationFinishing() {
        if (((XBReceivingFinished)((Object)this.declarationBuilderListener)).isFinished()) {
            this.typeConvertor = this.declaration.generateContext(this.parentContext, this.catalog);
            this.declarationBuilderListener = null;
        }
    }

    public void replaceCatalog(XBCatalog catalog, XBContext rootContext) {
        this.catalog = catalog;
    }
}

