/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.audio.swing.renderer;

import java.awt.Graphics;
import java.util.List;
import org.exbin.xbup.audio.swing.XBWavePanel;
import org.exbin.xbup.audio.swing.renderer.DefaultRenderer;
import org.exbin.xbup.audio.swing.renderer.XBWavePanelRenderer;
import org.exbin.xbup.audio.wave.XBWave;

public class DotsRenderer
extends DefaultRenderer {
    @Override
    public void paint(Graphics g, XBWavePanel panel, int begin, int end, XBWavePanelRenderer.RenderType renderType) {
        super.paint(g, panel, begin, end, renderType);
        double scaleRatio = panel.getScaleRatio();
        LineRecord lineRecord = new LineRecord();
        XBWave wave = panel.getWave();
        List<XBWave> zoomCache = panel.getZoomCache();
        int stopPos = end;
        if (wave != null) {
            g.setColor(panel.getWaveColor());
            int channelsCount = wave.getAudioFormat().getChannels();
            if ((double)stopPos >= (double)(panel.getWaveLength() - panel.getWindowPosition()) * scaleRatio) {
                stopPos = (int)((double)(panel.getWaveLength() - panel.getWindowPosition()) * scaleRatio) - 1;
            }
            LineRecord value = new LineRecord();
            for (int pos = begin; pos < stopPos; ++pos) {
                for (int channel = 0; channel < channelsCount; ++channel) {
                    int pomPos = pos;
                    if (pomPos < 0) {
                        pomPos = 0;
                    }
                    int height = panel.getHeight() / channelsCount;
                    int heightShift = channel * panel.getHeight() / channelsCount;
                    int zoomScale = this.getZoomScale(scaleRatio);
                    int linePosition = panel.getWindowPosition() / zoomScale + (int)((double)pomPos / (scaleRatio * (double)zoomScale));
                    this.getRatioValue(value, linePosition, channel, height, heightShift, panel, zoomScale);
                    lineRecord.min = value.min;
                    lineRecord.max = value.max;
                    if (scaleRatio < 1.0) {
                        int lineEndPosition = panel.getWindowPosition() / zoomScale + (int)((double)(pomPos + 1) / (scaleRatio * (double)zoomScale));
                        for (int inLinePosition = linePosition + 1; inLinePosition < lineEndPosition; ++inLinePosition) {
                            this.getRatioValue(value, inLinePosition, channel, height, heightShift, panel, zoomScale);
                            if (value.min < lineRecord.min) {
                                lineRecord.min = value.min;
                            }
                            if (value.max <= lineRecord.max) continue;
                            lineRecord.max = value.max;
                        }
                    }
                    if (renderType == XBWavePanelRenderer.RenderType.CURSOR) {
                        g.setColor(panel.getCursorWaveColor());
                        g.drawLine(pos, lineRecord.min, pos, lineRecord.max);
                        continue;
                    }
                    g.setColor(panel.getWaveFillColor());
                    g.drawLine(pos, lineRecord.min, pos, lineRecord.max);
                    g.setColor(panel.getWaveColor());
                    g.drawLine(pos, lineRecord.min, pos, lineRecord.min);
                    g.drawLine(pos, lineRecord.max, pos, lineRecord.max);
                }
            }
        }
    }

    private void getRatioValue(LineRecord record, int position, int channel, int height, int heightShift, XBWavePanel panel, int zoomScale) {
        if (zoomScale == 1) {
            int value;
            record.min = value = panel.getWave().getRatioValue(position, channel, height) + heightShift;
            record.max = value;
        } else {
            XBWave wave = zoomScale == 16 ? panel.getZoomCache().get(0) : panel.getZoomCache().get(1);
            record.min = wave.getRatioValue(position * 2, channel, height) + heightShift;
            record.max = wave.getRatioValue(position * 2 + 1, channel, height) + heightShift;
        }
    }

    private class LineRecord {
        int min;
        int max;

        private LineRecord() {
        }
    }
}

