/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.operation.undo.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.exbin.framework.operation.undo.handler.UndoManagerControlHandler;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.OkCancelListener;
import org.exbin.framework.utils.UiUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class UndoManagerControlPanel
extends JPanel
implements UndoManagerControlHandler.UndoManagerControlService {
    private final ResourceBundle resourceBundle;
    private UndoManagerControlHandler handler;
    private OkCancelListener okCancelListener;
    private JButton closeButton;
    private JButton revertButton;

    public UndoManagerControlPanel() {
        this(LanguageUtils.getResourceBundleByClass(UndoManagerControlPanel.class));
        this.initComponents();
        this.init();
    }

    public UndoManagerControlPanel(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.okCancelListener = new OkCancelListener(){

            public void okEvent() {
                UndoManagerControlPanel.this.performClick(UndoManagerControlHandler.ControlActionType.CANCEL);
            }

            public void cancelEvent() {
                UndoManagerControlPanel.this.performClick(UndoManagerControlHandler.ControlActionType.CANCEL);
            }
        };
    }

    public void setHandler(UndoManagerControlHandler handler) {
        this.handler = handler;
    }

    private void initComponents() {
        this.revertButton = new JButton();
        this.closeButton = new JButton();
        this.revertButton.setText(this.resourceBundle.getString("revertButton.text"));
        this.revertButton.setEnabled(false);
        this.revertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UndoManagerControlPanel.this.revertButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText(this.resourceBundle.getString("closeButton.text"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UndoManagerControlPanel.this.closeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.revertButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.closeButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.revertButton)).addContainerGap()));
    }

    private void revertButtonActionPerformed(ActionEvent evt) {
        if (this.handler != null) {
            this.handler.controlActionPerformed(UndoManagerControlHandler.ControlActionType.REVERT_TO);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        if (this.handler != null) {
            this.handler.controlActionPerformed(UndoManagerControlHandler.ControlActionType.CANCEL);
        }
    }

    @Override
    public void performClick(UndoManagerControlHandler.ControlActionType actionType) {
        switch (actionType) {
            case REVERT_TO: {
                UiUtils.doButtonClick((JButton)this.revertButton);
                break;
            }
            case CANCEL: {
                UiUtils.doButtonClick((JButton)this.closeButton);
            }
        }
    }

    @Nonnull
    public JButton getDefaultButton() {
        return this.closeButton;
    }

    @Nonnull
    public OkCancelListener getOkCancelListener() {
        return this.okCancelListener;
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new UndoManagerControlPanel());
    }
}

