/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.operation.undo.action;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.exbin.framework.operation.undo.OperationUndoModule;
import org.exbin.framework.operation.undo.api.UndoActions;
import org.exbin.framework.operation.undo.api.UndoActionsHandler;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;

public class BasicUndoActions
implements UndoActions {
    public static final String EDIT_UNDO_ACTION_ID = "editUndoAction";
    public static final String EDIT_REDO_ACTION_ID = "editRedoAction";
    public static final String EDIT_UNDO_MANAGER_ACTION_ID = "editUndoManagerAction";
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(OperationUndoModule.class);
    private UndoActionsHandler undoHandler = null;
    private Action undoAction = null;
    private Action redoAction = null;
    private Action undoManagerAction = null;

    public void updateUndoActions() {
        boolean canRedo;
        boolean canUndo = this.undoHandler != null && this.undoHandler.canUndo();
        boolean bl = canRedo = this.undoHandler != null && this.undoHandler.canRedo();
        if (this.undoAction != null) {
            this.undoAction.setEnabled(canUndo);
        }
        if (this.redoAction != null) {
            this.redoAction.setEnabled(canRedo);
        }
    }

    public void setUndoActionsHandler(UndoActionsHandler undoHandler) {
        this.undoHandler = undoHandler;
    }

    public Action getUndoAction() {
        if (this.undoAction == null) {
            this.undoAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasicUndoActions.this.undoHandler.performUndo();
                }
            };
            ActionUtils.setupAction((Action)this.undoAction, (ResourceBundle)this.resourceBundle, (String)EDIT_UNDO_ACTION_ID);
            this.undoAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, ActionUtils.getMetaMask()));
            this.undoAction.setEnabled(false);
        }
        return this.undoAction;
    }

    public Action getRedoAction() {
        if (this.redoAction == null) {
            this.redoAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasicUndoActions.this.undoHandler.performRedo();
                }
            };
            ActionUtils.setupAction((Action)this.redoAction, (ResourceBundle)this.resourceBundle, (String)EDIT_REDO_ACTION_ID);
            this.redoAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 0x40 | ActionUtils.getMetaMask()));
            this.redoAction.setEnabled(false);
        }
        return this.redoAction;
    }

    public Action getUndoManagerAction() {
        if (this.undoManagerAction == null) {
            this.undoManagerAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasicUndoActions.this.undoHandler.performUndoManager();
                }
            };
            this.undoManagerAction.putValue("dialogMode", true);
            ActionUtils.setupAction((Action)this.undoManagerAction, (ResourceBundle)this.resourceBundle, (String)EDIT_UNDO_MANAGER_ACTION_ID);
        }
        return this.undoManagerAction;
    }
}

