/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.service.skeleton;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.exbin.xbup.catalog.XBAECatalog;
import org.exbin.xbup.catalog.entity.XBEXLanguage;
import org.exbin.xbup.catalog.entity.service.XBEXLangService;
import org.exbin.xbup.client.stub.XBPXLangStub;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBTEmptyBlock;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.catalog.base.XBCXLanguage;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.remote.XBExecutable;
import org.exbin.xbup.core.remote.XBMultiProcedure;
import org.exbin.xbup.core.remote.XBServiceServer;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;
import org.exbin.xbup.core.stream.XBInput;
import org.exbin.xbup.core.stream.XBOutput;
import org.exbin.xbup.core.type.XBString;
import org.exbin.xbup.core.ubnumber.type.UBNat32;
import org.exbin.xbup.service.skeleton.XBPCatalogSkeleton;

public class XBPXLangSkeleton
implements XBPCatalogSkeleton {
    private XBAECatalog catalog;

    public XBPXLangSkeleton(XBAECatalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public void registerProcedures(XBServiceServer remoteServer) {
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXLangStub.CODE_LANG_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                provider.end();
                XBEXLangService langService = (XBEXLangService)XBPXLangSkeleton.this.catalog.getCatalogService(XBEXLangService.class);
                Optional lang = langService.getItem(index.getNaturalLong());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(lang.isPresent() ? new XBString(((XBCXLanguage)lang.get()).getLangCode()) : XBTEmptyBlock.getEmptyBlock()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXLangStub.DEFAULT_LANG_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                provider.end();
                XBEXLangService langService = (XBEXLangService)XBPXLangSkeleton.this.catalog.getCatalogService(XBEXLangService.class);
                XBEXLanguage lang = langService.getDefaultLang();
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(lang == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(lang.getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXLangStub.LANGS_LANG_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                provider.end();
                XBEXLangService langService = (XBEXLangService)XBPXLangSkeleton.this.catalog.getCatalogService(XBEXLangService.class);
                List items = langService.getAllItems();
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.begin();
                listener.matchType();
                listener.putAttribute(items.size());
                for (XBCXLanguage lang : items) {
                    listener.putAttribute(lang.getId());
                }
                listener.end();
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXLangStub.LANGSCOUNT_LANG_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                provider.end();
                XBEXLangService langService = (XBEXLangService)XBPXLangSkeleton.this.catalog.getCatalogService(XBEXLangService.class);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(langService.getItemsCount()));
            }
        });
    }

    @Override
    public void setCatalog(XBAECatalog catalog) {
        this.catalog = catalog;
    }
}

