/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.service.skeleton;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.exbin.xbup.client.stub.XBPBaseProcedureType;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.catalog.base.XBCBase;
import org.exbin.xbup.core.catalog.base.service.XBCService;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.remote.XBExecutable;
import org.exbin.xbup.core.remote.XBMultiProcedure;
import org.exbin.xbup.core.remote.XBServiceServer;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;
import org.exbin.xbup.core.stream.XBInput;
import org.exbin.xbup.core.stream.XBOutput;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

public class XBPBaseSkeleton<T extends XBCBase> {
    private final XBCService<T> service;
    private final XBPBaseProcedureType baseTypes;

    public XBPBaseSkeleton(XBCService<T> service, XBPBaseProcedureType baseTypes) {
        this.service = service;
        this.baseTypes = baseTypes;
    }

    public void registerProcedures(XBServiceServer remoteServer) {
        if (this.baseTypes.getItemByIdType() != null) {
            remoteServer.addXBProcedure(this.baseTypes.getItemByIdType(), (XBExecutable)new XBMultiProcedure(){

                public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                    XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                    provider.begin();
                    provider.matchType(blockType);
                    provider.end();
                    XBCBase item = XBPBaseSkeleton.this.service.createItem();
                    XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                    listener.process((XBSerializable)new UBNat32(item.getId()));
                }
            });
        }
        if (this.baseTypes.getCreateItemType() != null) {
            remoteServer.addXBProcedure(this.baseTypes.getCreateItemType(), (XBExecutable)new XBMultiProcedure(){

                public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                    XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                    provider.begin();
                    provider.matchType(blockType);
                    provider.end();
                    XBCBase item = XBPBaseSkeleton.this.service.createItem();
                    XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                    listener.process((XBSerializable)new UBNat32(item.getId()));
                }
            });
        }
        if (this.baseTypes.getRemoveItemType() != null) {
            remoteServer.addXBProcedure(this.baseTypes.getRemoveItemType(), (XBExecutable)new XBMultiProcedure(){

                public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                    XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                    provider.begin();
                    provider.matchType(blockType);
                    XBAttribute index = provider.pullAttribute();
                    provider.end();
                    Optional item = XBPBaseSkeleton.this.service.getItem(index.getNaturalLong());
                    if (!item.isPresent()) {
                        throw new XBProcessingException("Unable to remove item", XBProcessingExceptionType.UNKNOWN);
                    }
                    XBPBaseSkeleton.this.service.removeItem((XBCBase)item.get());
                }
            });
        }
        if (this.baseTypes.getAllItemsType() != null) {
            remoteServer.addXBProcedure(this.baseTypes.getAllItemsType(), (XBExecutable)new XBMultiProcedure(){

                public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                    XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                    provider.begin();
                    provider.matchType(blockType);
                    provider.end();
                    List items = XBPBaseSkeleton.this.service.getAllItems();
                    XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                    listener.begin();
                    listener.matchType();
                    listener.putAttribute(items.size());
                    for (XBCBase item : items) {
                        listener.putAttribute(item.getId());
                    }
                    listener.end();
                }
            });
        }
        if (this.baseTypes.getItemsCountType() != null) {
            remoteServer.addXBProcedure(this.baseTypes.getItemsCountType(), (XBExecutable)new XBMultiProcedure(){

                public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                    XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                    provider.begin();
                    provider.matchType(blockType);
                    provider.end();
                    XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                    listener.process((XBSerializable)new UBNat32(XBPBaseSkeleton.this.service.getItemsCount()));
                }
            });
        }
    }
}

