/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.inspector.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.InputMismatchException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.ByteArrayEditableData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.bined.CaretMovedListener;
import org.exbin.bined.CodeAreaCaretPosition;
import org.exbin.bined.DataChangedListener;
import org.exbin.bined.operation.BinaryDataCommand;
import org.exbin.bined.operation.BinaryDataOperationException;
import org.exbin.bined.operation.swing.command.BinaryCompoundCommand;
import org.exbin.bined.operation.swing.command.InsertDataCommand;
import org.exbin.bined.operation.swing.command.ModifyDataCommand;
import org.exbin.bined.operation.undo.BinaryDataUndoHandler;
import org.exbin.bined.operation.undo.BinaryDataUndoUpdateListener;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.framework.bined.inspector.BasicValuesPositionColorModifier;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class BasicValuesPanel
extends JPanel {
    public static final int UBYTE_MAX_VALUE = 255;
    public static final int SWORD_MIN_VALUE = Short.MIN_VALUE;
    public static final int SWORD_MAX_VALUE = Short.MAX_VALUE;
    public static final int UWORD_MAX_VALUE = 65535;
    public static final long UINT_MAX_VALUE = 0xFFFFFFFFL;
    public static final BigInteger ULONG_MAX_VALUE = new BigInteger("4294967295");
    public static final BigInteger BIG_INTEGER_BYTE_MASK = BigInteger.valueOf(255L);
    public static final String VALUE_OUT_OF_RANGE = "Value is out of range";
    public static int CACHE_SIZE = 250;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(BasicValuesPanel.class);
    private ExtCodeArea codeArea;
    private BinaryDataUndoHandler undoHandler;
    private long dataPosition;
    private DataChangedListener dataChangedListener;
    private CaretMovedListener caretMovedListener;
    private BinaryDataUndoUpdateListener undoUpdateListener;
    private final byte[] valuesCache = new byte[CACHE_SIZE];
    private final ByteBuffer byteBuffer = ByteBuffer.wrap(this.valuesCache);
    private final ValuesUpdater valuesUpdater = new ValuesUpdater();
    private JRadioButton bigEndianRadioButton;
    private JCheckBox binaryCheckBox0;
    private JCheckBox binaryCheckBox1;
    private JCheckBox binaryCheckBox2;
    private JCheckBox binaryCheckBox3;
    private JCheckBox binaryCheckBox4;
    private JCheckBox binaryCheckBox5;
    private JCheckBox binaryCheckBox6;
    private JCheckBox binaryCheckBox7;
    private JLabel binaryLabel;
    private JLabel byteLabel;
    private JTextField byteTextField;
    private JLabel characterLabel;
    private JTextField characterTextField;
    private JLabel doubleLabel;
    private JTextField doubleTextField;
    private ButtonGroup endianButtonGroup;
    private JLabel floatLabel;
    private JTextField floatTextField;
    private JLabel intLabel;
    private JTextField intTextField;
    private ButtonGroup integerSignButtonGroup;
    private JSeparator jSeparator1;
    private JRadioButton littleEndianRadioButton;
    private JLabel longLabel;
    private JTextField longTextField;
    private JRadioButton signedRadioButton;
    private JLabel stringLabel;
    private JTextField stringTextField;
    private JRadioButton unsignedRadioButton;
    private JLabel wordLabel;
    private JTextField wordTextField;

    public BasicValuesPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.endianButtonGroup = new ButtonGroup();
        this.integerSignButtonGroup = new ButtonGroup();
        this.binaryLabel = new JLabel();
        this.binaryCheckBox0 = new JCheckBox();
        this.binaryCheckBox1 = new JCheckBox();
        this.binaryCheckBox2 = new JCheckBox();
        this.binaryCheckBox3 = new JCheckBox();
        this.binaryCheckBox4 = new JCheckBox();
        this.binaryCheckBox5 = new JCheckBox();
        this.binaryCheckBox6 = new JCheckBox();
        this.binaryCheckBox7 = new JCheckBox();
        this.byteLabel = new JLabel();
        this.byteTextField = new JTextField();
        this.wordLabel = new JLabel();
        this.wordTextField = new JTextField();
        this.intLabel = new JLabel();
        this.intTextField = new JTextField();
        this.longLabel = new JLabel();
        this.longTextField = new JTextField();
        this.floatLabel = new JLabel();
        this.floatTextField = new JTextField();
        this.doubleLabel = new JLabel();
        this.doubleTextField = new JTextField();
        this.characterLabel = new JLabel();
        this.characterTextField = new JTextField();
        this.stringLabel = new JLabel();
        this.stringTextField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.bigEndianRadioButton = new JRadioButton();
        this.littleEndianRadioButton = new JRadioButton();
        this.signedRadioButton = new JRadioButton();
        this.unsignedRadioButton = new JRadioButton();
        this.setMaximumSize(new Dimension(246, 447));
        this.setMinimumSize(new Dimension(246, 447));
        this.binaryLabel.setText(this.resourceBundle.getString("binaryLabel.text"));
        this.binaryCheckBox0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicValuesPanel.this.binaryCheckBox0ActionPerformed(evt);
            }
        });
        this.binaryCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicValuesPanel.this.binaryCheckBox1ActionPerformed(evt);
            }
        });
        this.binaryCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicValuesPanel.this.binaryCheckBox2ActionPerformed(evt);
            }
        });
        this.binaryCheckBox3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicValuesPanel.this.binaryCheckBox3ActionPerformed(evt);
            }
        });
        this.binaryCheckBox4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicValuesPanel.this.binaryCheckBox4ActionPerformed(evt);
            }
        });
        this.binaryCheckBox5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicValuesPanel.this.binaryCheckBox5ActionPerformed(evt);
            }
        });
        this.binaryCheckBox6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicValuesPanel.this.binaryCheckBox6ActionPerformed(evt);
            }
        });
        this.binaryCheckBox7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicValuesPanel.this.binaryCheckBox7ActionPerformed(evt);
            }
        });
        this.byteLabel.setText(this.resourceBundle.getString("byteLabel.text"));
        this.byteTextField.setEditable(false);
        this.byteTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                BasicValuesPanel.this.byteTextFieldKeyReleased(evt);
            }
        });
        this.wordLabel.setText("Word");
        this.wordTextField.setEditable(false);
        this.wordTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                BasicValuesPanel.this.wordTextFieldKeyReleased(evt);
            }
        });
        this.intLabel.setText(this.resourceBundle.getString("intLabel.text"));
        this.intTextField.setEditable(false);
        this.intTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                BasicValuesPanel.this.intTextFieldKeyReleased(evt);
            }
        });
        this.longLabel.setText(this.resourceBundle.getString("longLabel.text"));
        this.longTextField.setEditable(false);
        this.longTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                BasicValuesPanel.this.longTextFieldKeyReleased(evt);
            }
        });
        this.floatLabel.setText(this.resourceBundle.getString("floatLabel.text"));
        this.floatTextField.setEditable(false);
        this.floatTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                BasicValuesPanel.this.floatTextFieldKeyReleased(evt);
            }
        });
        this.doubleLabel.setText(this.resourceBundle.getString("doubleLabel.text"));
        this.doubleTextField.setEditable(false);
        this.doubleTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                BasicValuesPanel.this.doubleTextFieldKeyReleased(evt);
            }
        });
        this.characterLabel.setText(this.resourceBundle.getString("characterLabel.text"));
        this.characterTextField.setEditable(false);
        this.characterTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                BasicValuesPanel.this.characterTextFieldKeyReleased(evt);
            }
        });
        this.stringLabel.setText(this.resourceBundle.getString("stringLabel.text"));
        this.stringTextField.setEditable(false);
        this.stringTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                BasicValuesPanel.this.stringTextFieldKeyReleased(evt);
            }
        });
        this.jSeparator1.setOrientation(1);
        this.endianButtonGroup.add(this.bigEndianRadioButton);
        this.bigEndianRadioButton.setSelected(true);
        this.bigEndianRadioButton.setText(this.resourceBundle.getString("bigEndianRadioButton.text"));
        this.bigEndianRadioButton.setToolTipText("Big Endian");
        this.bigEndianRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                BasicValuesPanel.this.bigEndianRadioButtonStateChanged(evt);
            }
        });
        this.endianButtonGroup.add(this.littleEndianRadioButton);
        this.littleEndianRadioButton.setText(this.resourceBundle.getString("littleEndianRadioButton.text"));
        this.littleEndianRadioButton.setToolTipText("Little Endian");
        this.littleEndianRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                BasicValuesPanel.this.littleEndianRadioButtonStateChanged(evt);
            }
        });
        this.integerSignButtonGroup.add(this.signedRadioButton);
        this.signedRadioButton.setSelected(true);
        this.signedRadioButton.setText(this.resourceBundle.getString("signedRadioButton.text"));
        this.signedRadioButton.setToolTipText("Signed Integers");
        this.signedRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                BasicValuesPanel.this.signedRadioButtonStateChanged(evt);
            }
        });
        this.integerSignButtonGroup.add(this.unsignedRadioButton);
        this.unsignedRadioButton.setText(this.resourceBundle.getString("unsignedRadioButton.text"));
        this.unsignedRadioButton.setToolTipText("Unsigned Integers");
        this.unsignedRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                BasicValuesPanel.this.unsignedRadioButtonStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.bigEndianRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.littleEndianRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.signedRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unsignedRadioButton, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.characterTextField, -2, 234, -2).addComponent(this.byteTextField, -2, 234, -2).addComponent(this.wordTextField, -2, 234, -2).addComponent(this.intTextField, -2, 234, -2).addComponent(this.longTextField, -2, 234, -2).addComponent(this.floatTextField, -2, 234, -2).addComponent(this.byteLabel).addComponent(this.wordLabel).addComponent(this.intLabel).addComponent(this.longLabel).addComponent(this.binaryLabel).addGroup(layout.createSequentialGroup().addComponent(this.binaryCheckBox0).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.binaryCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.binaryCheckBox2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.binaryCheckBox3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.binaryCheckBox4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.binaryCheckBox5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.binaryCheckBox6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.binaryCheckBox7)).addComponent(this.floatLabel).addComponent(this.doubleLabel).addComponent(this.doubleTextField, -2, 234, -2).addComponent(this.characterLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.stringTextField, GroupLayout.Alignment.TRAILING, -2, 234, -2).addComponent(this.stringLabel))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.binaryLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.binaryCheckBox0).addComponent(this.binaryCheckBox1).addComponent(this.binaryCheckBox2).addComponent(this.binaryCheckBox3).addComponent(this.binaryCheckBox4).addComponent(this.binaryCheckBox5).addComponent(this.binaryCheckBox6).addComponent(this.binaryCheckBox7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.byteLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.byteTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wordLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wordTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.intLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.intTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.longLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.longTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.floatLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.floatTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.doubleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.doubleTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.characterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.characterTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stringLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stringTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bigEndianRadioButton).addComponent(this.littleEndianRadioButton)).addComponent(this.jSeparator1, -2, 28, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.signedRadioButton).addComponent(this.unsignedRadioButton))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void littleEndianRadioButtonStateChanged(ChangeEvent evt) {
        this.updateValues();
    }

    private void bigEndianRadioButtonStateChanged(ChangeEvent evt) {
        this.updateValues();
    }

    private void signedRadioButtonStateChanged(ChangeEvent evt) {
        this.updateValues();
    }

    private void unsignedRadioButtonStateChanged(ChangeEvent evt) {
        this.updateValues();
    }

    private void binaryCheckBox0ActionPerformed(ActionEvent evt) {
        if (!this.valuesUpdater.isUpdateInProgress() && (this.valuesCache[0] & 0x80) > 0 != this.binaryCheckBox0.isSelected()) {
            this.valuesCache[0] = (byte)(this.valuesCache[0] ^ 0x80);
            this.modifyValues(1);
        }
    }

    private void binaryCheckBox1ActionPerformed(ActionEvent evt) {
        if (!this.valuesUpdater.isUpdateInProgress() && (this.valuesCache[0] & 0x40) > 0 != this.binaryCheckBox1.isSelected()) {
            this.valuesCache[0] = (byte)(this.valuesCache[0] ^ 0x40);
            this.modifyValues(1);
        }
    }

    private void binaryCheckBox2ActionPerformed(ActionEvent evt) {
        if (!this.valuesUpdater.isUpdateInProgress() && (this.valuesCache[0] & 0x20) > 0 != this.binaryCheckBox2.isSelected()) {
            this.valuesCache[0] = (byte)(this.valuesCache[0] ^ 0x20);
            this.modifyValues(1);
        }
    }

    private void binaryCheckBox3ActionPerformed(ActionEvent evt) {
        if (!this.valuesUpdater.isUpdateInProgress() && (this.valuesCache[0] & 0x10) > 0 != this.binaryCheckBox3.isSelected()) {
            this.valuesCache[0] = (byte)(this.valuesCache[0] ^ 0x10);
            this.modifyValues(1);
        }
    }

    private void binaryCheckBox4ActionPerformed(ActionEvent evt) {
        if (!this.valuesUpdater.isUpdateInProgress() && (this.valuesCache[0] & 8) > 0 != this.binaryCheckBox4.isSelected()) {
            this.valuesCache[0] = (byte)(this.valuesCache[0] ^ 8);
            this.modifyValues(1);
        }
    }

    private void binaryCheckBox5ActionPerformed(ActionEvent evt) {
        if (!this.valuesUpdater.isUpdateInProgress() && (this.valuesCache[0] & 4) > 0 != this.binaryCheckBox5.isSelected()) {
            this.valuesCache[0] = (byte)(this.valuesCache[0] ^ 4);
            this.modifyValues(1);
        }
    }

    private void binaryCheckBox6ActionPerformed(ActionEvent evt) {
        if (!this.valuesUpdater.isUpdateInProgress() && (this.valuesCache[0] & 2) > 0 != this.binaryCheckBox6.isSelected()) {
            this.valuesCache[0] = (byte)(this.valuesCache[0] ^ 2);
            this.modifyValues(1);
        }
    }

    private void binaryCheckBox7ActionPerformed(ActionEvent evt) {
        if (!this.valuesUpdater.isUpdateInProgress() && (this.valuesCache[0] & 1) > 0 != this.binaryCheckBox7.isSelected()) {
            this.valuesCache[0] = (byte)(this.valuesCache[0] ^ 1);
            this.modifyValues(1);
        }
    }

    private void byteTextFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && this.isEditable()) {
            try {
                int intValue = Integer.parseInt(this.byteTextField.getText());
                if (this.isSigned() ? intValue < -128 || intValue > 127 : intValue < 0 || intValue > 255) {
                    throw new NumberFormatException(VALUE_OUT_OF_RANGE);
                }
                this.valuesCache[0] = (byte)intValue;
                this.modifyValues(1);
                this.updateValues();
            }
            catch (NumberFormatException ex) {
                this.showException(ex);
            }
        }
    }

    private void wordTextFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && this.isEditable()) {
            try {
                int intValue = Integer.parseInt(this.wordTextField.getText());
                if (this.isSigned() ? intValue < Short.MIN_VALUE || intValue > Short.MAX_VALUE : intValue < 0 || intValue > 65535) {
                    throw new NumberFormatException(VALUE_OUT_OF_RANGE);
                }
                if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
                    this.valuesCache[0] = (byte)(intValue & 0xFF);
                    this.valuesCache[1] = (byte)(intValue >> 8 & 0xFF);
                } else {
                    this.valuesCache[0] = (byte)(intValue >> 8 & 0xFF);
                    this.valuesCache[1] = (byte)(intValue & 0xFF);
                }
                this.modifyValues(2);
                this.updateValues();
            }
            catch (NumberFormatException ex) {
                this.showException(ex);
            }
        }
    }

    private void intTextFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && this.isEditable()) {
            try {
                long longValue = Long.parseLong(this.intTextField.getText());
                if (this.isSigned() ? longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE : longValue < 0L || longValue > 0xFFFFFFFFL) {
                    throw new NumberFormatException(VALUE_OUT_OF_RANGE);
                }
                if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
                    this.valuesCache[0] = (byte)(longValue & 0xFFL);
                    this.valuesCache[1] = (byte)(longValue >> 8 & 0xFFL);
                    this.valuesCache[2] = (byte)(longValue >> 16 & 0xFFL);
                    this.valuesCache[3] = (byte)(longValue >> 24 & 0xFFL);
                } else {
                    this.valuesCache[0] = (byte)(longValue >> 24 & 0xFFL);
                    this.valuesCache[1] = (byte)(longValue >> 16 & 0xFFL);
                    this.valuesCache[2] = (byte)(longValue >> 8 & 0xFFL);
                    this.valuesCache[3] = (byte)(longValue & 0xFFL);
                }
                this.modifyValues(4);
                this.updateValues();
            }
            catch (NumberFormatException ex) {
                this.showException(ex);
            }
        }
    }

    private void longTextFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && this.isEditable()) {
            try {
                ByteOrder byteOrder = this.getByteOrder();
                if (this.isSigned()) {
                    long longValue = Long.parseLong(this.longTextField.getText());
                    this.byteBuffer.rewind();
                    if (this.byteBuffer.order() != byteOrder) {
                        this.byteBuffer.order(byteOrder);
                    }
                    this.byteBuffer.putLong(longValue);
                } else {
                    BigInteger bigInteger = new BigInteger(this.longTextField.getText());
                    if (bigInteger.compareTo(BigInteger.ZERO) == -1 || bigInteger.compareTo(ULONG_MAX_VALUE) == 1) {
                        throw new NumberFormatException(VALUE_OUT_OF_RANGE);
                    }
                    if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                        for (int i = 0; i < 7; ++i) {
                            BigInteger nextByte = bigInteger.and(BIG_INTEGER_BYTE_MASK);
                            this.valuesCache[7 - i] = nextByte.byteValue();
                            bigInteger = bigInteger.shiftRight(8);
                        }
                    } else {
                        for (int i = 0; i < 7; ++i) {
                            BigInteger nextByte = bigInteger.and(BIG_INTEGER_BYTE_MASK);
                            this.valuesCache[i] = nextByte.byteValue();
                            bigInteger = bigInteger.shiftRight(8);
                        }
                    }
                }
                this.modifyValues(8);
                this.updateValues();
            }
            catch (NumberFormatException ex) {
                this.showException(ex);
            }
        }
    }

    private void floatTextFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && this.isEditable()) {
            try {
                ByteOrder byteOrder = this.getByteOrder();
                float floatValue = Float.parseFloat(this.floatTextField.getText());
                this.byteBuffer.rewind();
                if (this.byteBuffer.order() != byteOrder) {
                    this.byteBuffer.order(byteOrder);
                }
                this.byteBuffer.putFloat(floatValue);
                this.modifyValues(4);
                this.updateValues();
            }
            catch (NumberFormatException ex) {
                this.showException(ex);
            }
        }
    }

    private void doubleTextFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && this.isEditable()) {
            try {
                ByteOrder byteOrder = this.getByteOrder();
                double doubleValue = Double.parseDouble(this.doubleTextField.getText());
                this.byteBuffer.rewind();
                if (this.byteBuffer.order() != byteOrder) {
                    this.byteBuffer.order(byteOrder);
                }
                this.byteBuffer.putDouble(doubleValue);
                this.modifyValues(8);
                this.updateValues();
            }
            catch (NumberFormatException ex) {
                this.showException(ex);
            }
        }
    }

    private void characterTextFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && this.isEditable()) {
            try {
                String characterText = this.characterTextField.getText();
                if (characterText.isEmpty()) {
                    throw new InputMismatchException("Empty value not valid");
                }
                if (characterText.length() > 1) {
                    throw new InputMismatchException("Only single character allowed");
                }
                byte[] bytes = characterText.getBytes(this.codeArea.getCharset());
                System.arraycopy(bytes, 0, this.valuesCache, 0, bytes.length);
                this.modifyValues(bytes.length);
                this.updateValues();
            }
            catch (InputMismatchException ex) {
                this.showException(ex);
            }
        }
    }

    private void stringTextFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && this.isEditable()) {
            try {
                String characterText = this.stringTextField.getText();
                if (characterText.isEmpty()) {
                    throw new InputMismatchException("Empty value not valid");
                }
                byte[] bytes = characterText.getBytes(this.codeArea.getCharset());
                if (bytes.length > CACHE_SIZE) {
                    throw new InputMismatchException("String is too long");
                }
                System.arraycopy(bytes, 0, this.valuesCache, 0, bytes.length);
                this.modifyValues(bytes.length);
                this.updateValues();
            }
            catch (InputMismatchException ex) {
                this.showException(ex);
            }
        }
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new BasicValuesPanel());
    }

    public void setCodeArea(ExtCodeArea codeArea, @Nullable BinaryDataUndoHandler undoHandler) {
        this.codeArea = codeArea;
        this.undoHandler = undoHandler;
    }

    public void enableUpdate() {
        this.dataChangedListener = () -> {
            this.updateEditMode();
            this.updateValues();
        };
        this.codeArea.addDataChangedListener(this.dataChangedListener);
        this.caretMovedListener = caretPosition -> this.updateValues();
        this.codeArea.addCaretMovedListener(this.caretMovedListener);
        this.undoUpdateListener = new BinaryDataUndoUpdateListener(){

            public void undoCommandPositionChanged() {
                BasicValuesPanel.this.updateValues();
            }

            public void undoCommandAdded(BinaryDataCommand command) {
                BasicValuesPanel.this.updateValues();
            }
        };
        if (this.undoHandler != null) {
            this.undoHandler.addUndoUpdateListener(this.undoUpdateListener);
        }
        this.updateEditMode();
        this.updateValues();
    }

    public void disableUpdate() {
        this.codeArea.removeDataChangedListener(this.dataChangedListener);
        this.codeArea.removeCaretMovedListener(this.caretMovedListener);
        if (this.undoHandler != null) {
            this.undoHandler.addUndoUpdateListener(this.undoUpdateListener);
        }
    }

    public void updateEditMode() {
        boolean editable = this.isEditable();
        this.binaryCheckBox0.setEnabled(editable);
        this.binaryCheckBox1.setEnabled(editable);
        this.binaryCheckBox2.setEnabled(editable);
        this.binaryCheckBox3.setEnabled(editable);
        this.binaryCheckBox4.setEnabled(editable);
        this.binaryCheckBox5.setEnabled(editable);
        this.binaryCheckBox6.setEnabled(editable);
        this.binaryCheckBox7.setEnabled(editable);
        this.byteTextField.setEditable(editable);
        this.wordTextField.setEditable(editable);
        this.intTextField.setEditable(editable);
        this.longTextField.setEditable(editable);
        this.floatTextField.setEditable(editable);
        this.doubleTextField.setEditable(editable);
        this.characterTextField.setEditable(editable);
        this.stringTextField.setEditable(editable);
    }

    public void updateValues() {
        CodeAreaCaretPosition caretPosition = this.codeArea.getCaretPosition();
        this.dataPosition = caretPosition.getDataPosition();
        long dataSize = this.codeArea.getDataSize();
        if (this.dataPosition < dataSize) {
            int availableData = dataSize - this.dataPosition >= (long)CACHE_SIZE ? CACHE_SIZE : (int)(dataSize - this.dataPosition);
            BinaryData contentData = this.codeArea.getContentData();
            contentData.copyToArray(this.dataPosition, this.valuesCache, 0, availableData);
            if (availableData < CACHE_SIZE) {
                Arrays.fill(this.valuesCache, availableData, CACHE_SIZE, (byte)0);
            }
        }
        this.valuesUpdater.schedule();
    }

    private void modifyValues(int bytesCount) {
        ByteArrayEditableData byteArrayData = new ByteArrayEditableData();
        byteArrayData.insert(0L, this.valuesCache, 0, bytesCount);
        long oldDataPosition = this.dataPosition;
        if (this.dataPosition == this.codeArea.getDataSize()) {
            InsertDataCommand insertCommand = new InsertDataCommand((CodeAreaCore)this.codeArea, this.dataPosition, (BinaryData)byteArrayData);
            if (this.undoHandler != null) {
                try {
                    this.undoHandler.execute((BinaryDataCommand)insertCommand);
                }
                catch (BinaryDataOperationException ex) {
                    Logger.getLogger(BasicValuesPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else {
            ModifyDataCommand command;
            if (this.dataPosition + byteArrayData.getDataSize() > this.codeArea.getDataSize()) {
                long modifiedDataSize = this.codeArea.getDataSize() - this.dataPosition;
                EditableBinaryData modifiedData = (EditableBinaryData)byteArrayData.copy(0L, modifiedDataSize);
                EditableBinaryData insertedData = (EditableBinaryData)byteArrayData.copy(modifiedDataSize, byteArrayData.getDataSize() - modifiedDataSize);
                command = new BinaryCompoundCommand((CodeAreaCore)this.codeArea);
                ((BinaryCompoundCommand)command).appendCommand((BinaryDataCommand)new ModifyDataCommand((CodeAreaCore)this.codeArea, this.dataPosition, (BinaryData)modifiedData));
                ((BinaryCompoundCommand)command).appendCommand((BinaryDataCommand)new InsertDataCommand((CodeAreaCore)this.codeArea, this.dataPosition + modifiedDataSize, (BinaryData)insertedData));
            } else {
                command = new ModifyDataCommand((CodeAreaCore)this.codeArea, this.dataPosition, (BinaryData)byteArrayData);
            }
            if (this.undoHandler != null) {
                try {
                    this.undoHandler.execute((BinaryDataCommand)command);
                }
                catch (BinaryDataOperationException ex) {
                    Logger.getLogger(BasicValuesPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        this.codeArea.setCaretPosition(oldDataPosition);
        this.codeArea.repaint();
    }

    private boolean isSigned() {
        return this.signedRadioButton.isSelected();
    }

    private boolean isEditable() {
        return this.codeArea.isEditable();
    }

    @Nonnull
    private ByteOrder getByteOrder() {
        return this.littleEndianRadioButton.isSelected() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    private void showException(Exception ex) {
        JOptionPane.showMessageDialog(this, ex.getMessage(), "Invalid Input", 0);
    }

    public void registerFocusPainter(BasicValuesPositionColorModifier colorModifier) {
        this.byteTextField.addFocusListener(new ValueFocusListener(colorModifier, 1));
        this.wordTextField.addFocusListener(new ValueFocusListener(colorModifier, 2));
        this.intTextField.addFocusListener(new ValueFocusListener(colorModifier, 4));
        this.longTextField.addFocusListener(new ValueFocusListener(colorModifier, 8));
        this.floatTextField.addFocusListener(new ValueFocusListener(colorModifier, 4));
        this.doubleTextField.addFocusListener(new ValueFocusListener(colorModifier, 8));
        this.characterTextField.addFocusListener(new ValueFocusListener(colorModifier, 1));
        this.stringTextField.addFocusListener(new ValueFocusListener(colorModifier, 1));
    }

    @ParametersAreNonnullByDefault
    private class ValueFocusListener
    implements FocusListener {
        private BasicValuesPositionColorModifier colorModifier;
        private int length;

        public ValueFocusListener(BasicValuesPositionColorModifier colorModifier, int length) {
            this.colorModifier = colorModifier;
            this.length = length;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.colorModifier.setRange(BasicValuesPanel.this.dataPosition, this.length);
            BasicValuesPanel.this.codeArea.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.colorModifier.clearRange();
            BasicValuesPanel.this.codeArea.repaint();
        }
    }

    @ParametersAreNonnullByDefault
    private class ValuesUpdater {
        private boolean updateInProgress = false;
        private boolean updateTerminated = false;
        private boolean scheduleUpdate = false;
        private boolean clearFields = true;
        private boolean signed;
        private ByteOrder byteOrder;
        private byte[] values;

        private ValuesUpdater() {
        }

        private synchronized void schedule() {
            if (this.updateInProgress) {
                this.updateTerminated = true;
            }
            if (!this.scheduleUpdate) {
                this.scheduleUpdate = true;
                this.scheduleNextStep(ValuesPanelField.values()[0]);
            }
        }

        private void scheduleNextStep(ValuesPanelField valuesPanelField) {
            SwingUtilities.invokeLater(() -> this.updateValue(valuesPanelField));
        }

        public boolean isUpdateInProgress() {
            return this.updateInProgress;
        }

        private void updateValue(ValuesPanelField valuesPanelField) {
            if (valuesPanelField.ordinal() == 0) {
                long dataSize = BasicValuesPanel.this.codeArea.getDataSize();
                this.clearFields = BasicValuesPanel.this.dataPosition >= dataSize;
                this.byteOrder = BasicValuesPanel.this.littleEndianRadioButton.isSelected() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
                this.byteOrder = BasicValuesPanel.this.getByteOrder();
                this.signed = BasicValuesPanel.this.isSigned();
                this.values = BasicValuesPanel.this.valuesCache;
                if (this.clearFields) {
                    this.values[0] = 0;
                }
                this.updateStarted();
            }
            if (this.updateTerminated) {
                this.stopUpdate();
                return;
            }
            if (this.clearFields) {
                this.clearField(valuesPanelField);
            } else {
                this.updateField(valuesPanelField);
            }
            ValuesPanelField[] panelFields = ValuesPanelField.values();
            ValuesPanelField lastValue = panelFields[panelFields.length - 1];
            if (valuesPanelField == lastValue) {
                this.stopUpdate();
            } else {
                SwingUtilities.invokeLater(() -> {
                    ValuesPanelField nextValue = panelFields[valuesPanelField.ordinal() + 1];
                    this.updateValue(nextValue);
                });
            }
        }

        private void updateField(ValuesPanelField valuesPanelField) {
            switch (valuesPanelField) {
                case BINARY0: {
                    BasicValuesPanel.this.binaryCheckBox0.setSelected((this.values[0] & 0x80) > 0);
                    break;
                }
                case BINARY1: {
                    BasicValuesPanel.this.binaryCheckBox1.setSelected((this.values[0] & 0x40) > 0);
                    break;
                }
                case BINARY2: {
                    BasicValuesPanel.this.binaryCheckBox2.setSelected((this.values[0] & 0x20) > 0);
                    break;
                }
                case BINARY3: {
                    BasicValuesPanel.this.binaryCheckBox3.setSelected((this.values[0] & 0x10) > 0);
                    break;
                }
                case BINARY4: {
                    BasicValuesPanel.this.binaryCheckBox4.setSelected((this.values[0] & 8) > 0);
                    break;
                }
                case BINARY5: {
                    BasicValuesPanel.this.binaryCheckBox5.setSelected((this.values[0] & 4) > 0);
                    break;
                }
                case BINARY6: {
                    BasicValuesPanel.this.binaryCheckBox6.setSelected((this.values[0] & 2) > 0);
                    break;
                }
                case BINARY7: {
                    BasicValuesPanel.this.binaryCheckBox7.setSelected((this.values[0] & 1) > 0);
                    break;
                }
                case BYTE: {
                    BasicValuesPanel.this.byteTextField.setText(String.valueOf(this.signed ? this.values[0] : this.values[0] & 0xFF));
                    break;
                }
                case WORD: {
                    int wordValue = this.signed ? (this.byteOrder == ByteOrder.LITTLE_ENDIAN ? this.values[0] & 0xFF | this.values[1] << 8 : this.values[1] & 0xFF | this.values[0] << 8) : (this.byteOrder == ByteOrder.LITTLE_ENDIAN ? this.values[0] & 0xFF | (this.values[1] & 0xFF) << 8 : this.values[1] & 0xFF | (this.values[0] & 0xFF) << 8);
                    BasicValuesPanel.this.wordTextField.setText(String.valueOf(wordValue));
                    break;
                }
                case INTEGER: {
                    long intValue = this.signed ? (this.byteOrder == ByteOrder.LITTLE_ENDIAN ? (long)this.values[0] & 0xFFL | ((long)this.values[1] & 0xFFL) << 8 | ((long)this.values[2] & 0xFFL) << 16 | (long)(this.values[3] << 24) : (long)this.values[3] & 0xFFL | ((long)this.values[2] & 0xFFL) << 8 | ((long)this.values[1] & 0xFFL) << 16 | (long)(this.values[0] << 24)) : (this.byteOrder == ByteOrder.LITTLE_ENDIAN ? (long)this.values[0] & 0xFFL | ((long)this.values[1] & 0xFFL) << 8 | ((long)this.values[2] & 0xFFL) << 16 | ((long)this.values[3] & 0xFFL) << 24 : (long)this.values[3] & 0xFFL | ((long)this.values[2] & 0xFFL) << 8 | ((long)this.values[1] & 0xFFL) << 16 | ((long)this.values[0] & 0xFFL) << 24);
                    BasicValuesPanel.this.intTextField.setText(String.valueOf(intValue));
                    break;
                }
                case LONG: {
                    if (this.signed) {
                        BasicValuesPanel.this.byteBuffer.rewind();
                        if (BasicValuesPanel.this.byteBuffer.order() != this.byteOrder) {
                            BasicValuesPanel.this.byteBuffer.order(this.byteOrder);
                        }
                        BasicValuesPanel.this.longTextField.setText(String.valueOf(BasicValuesPanel.this.byteBuffer.getLong()));
                        break;
                    }
                    long longValue = this.byteOrder == ByteOrder.LITTLE_ENDIAN ? (long)this.values[0] & 0xFFL | ((long)this.values[1] & 0xFFL) << 8 | ((long)this.values[2] & 0xFFL) << 16 | ((long)this.values[3] & 0xFFL) << 24 | ((long)this.values[4] & 0xFFL) << 32 | ((long)this.values[5] & 0xFFL) << 40 | ((long)this.values[6] & 0xFFL) << 48 : (long)this.values[7] & 0xFFL | ((long)this.values[6] & 0xFFL) << 8 | ((long)this.values[5] & 0xFFL) << 16 | ((long)this.values[4] & 0xFFL) << 24 | ((long)this.values[3] & 0xFFL) << 32 | ((long)this.values[2] & 0xFFL) << 40 | ((long)this.values[1] & 0xFFL) << 48;
                    BigInteger bigInt1 = BigInteger.valueOf((long)this.values[this.byteOrder == ByteOrder.LITTLE_ENDIAN ? 7 : 0] & 0xFFL);
                    BigInteger bigInt2 = bigInt1.shiftLeft(56);
                    BigInteger bigInt3 = bigInt2.add(BigInteger.valueOf(longValue));
                    BasicValuesPanel.this.longTextField.setText(bigInt3.toString());
                    break;
                }
                case FLOAT: {
                    BasicValuesPanel.this.byteBuffer.rewind();
                    if (BasicValuesPanel.this.byteBuffer.order() != this.byteOrder) {
                        BasicValuesPanel.this.byteBuffer.order(this.byteOrder);
                    }
                    BasicValuesPanel.this.floatTextField.setText(String.valueOf(BasicValuesPanel.this.byteBuffer.getFloat()));
                    break;
                }
                case DOUBLE: {
                    BasicValuesPanel.this.byteBuffer.rewind();
                    if (BasicValuesPanel.this.byteBuffer.order() != this.byteOrder) {
                        BasicValuesPanel.this.byteBuffer.order(this.byteOrder);
                    }
                    BasicValuesPanel.this.doubleTextField.setText(String.valueOf(BasicValuesPanel.this.byteBuffer.getDouble()));
                    break;
                }
                case CHARACTER: {
                    String strValue = new String(this.values, BasicValuesPanel.this.codeArea.getCharset());
                    if (strValue.length() > 0) {
                        BasicValuesPanel.this.characterTextField.setText(strValue.substring(0, 1));
                        break;
                    }
                    BasicValuesPanel.this.characterTextField.setText("");
                    break;
                }
                case STRING: {
                    String strValue = new String(this.values, BasicValuesPanel.this.codeArea.getCharset());
                    for (int i = 0; i < strValue.length(); ++i) {
                        char charAt = strValue.charAt(i);
                        if (charAt != '\r' && charAt != '\n' && charAt != '\u0000') continue;
                        strValue = strValue.substring(0, i);
                        break;
                    }
                    BasicValuesPanel.this.stringTextField.setText(strValue);
                    BasicValuesPanel.this.stringTextField.setCaretPosition(0);
                    break;
                }
            }
        }

        private void clearField(ValuesPanelField valuesPanelField) {
            switch (valuesPanelField) {
                case BINARY0: {
                    BasicValuesPanel.this.binaryCheckBox0.setSelected(false);
                    break;
                }
                case BINARY1: {
                    BasicValuesPanel.this.binaryCheckBox1.setSelected(false);
                    break;
                }
                case BINARY2: {
                    BasicValuesPanel.this.binaryCheckBox2.setSelected(false);
                    break;
                }
                case BINARY3: {
                    BasicValuesPanel.this.binaryCheckBox3.setSelected(false);
                    break;
                }
                case BINARY4: {
                    BasicValuesPanel.this.binaryCheckBox4.setSelected(false);
                    break;
                }
                case BINARY5: {
                    BasicValuesPanel.this.binaryCheckBox5.setSelected(false);
                    break;
                }
                case BINARY6: {
                    BasicValuesPanel.this.binaryCheckBox6.setSelected(false);
                    break;
                }
                case BINARY7: {
                    BasicValuesPanel.this.binaryCheckBox7.setSelected(false);
                    break;
                }
                case BYTE: {
                    BasicValuesPanel.this.byteTextField.setText("");
                    break;
                }
                case WORD: {
                    BasicValuesPanel.this.wordTextField.setText("");
                    break;
                }
                case INTEGER: {
                    BasicValuesPanel.this.intTextField.setText("");
                    break;
                }
                case LONG: {
                    BasicValuesPanel.this.longTextField.setText("");
                    break;
                }
                case FLOAT: {
                    BasicValuesPanel.this.floatTextField.setText("");
                    break;
                }
                case DOUBLE: {
                    BasicValuesPanel.this.doubleTextField.setText("");
                    break;
                }
                case CHARACTER: {
                    BasicValuesPanel.this.characterTextField.setText("");
                    break;
                }
                case STRING: {
                    BasicValuesPanel.this.stringTextField.setText("");
                }
            }
        }

        private synchronized void updateStarted() {
            this.updateInProgress = true;
            this.scheduleUpdate = false;
        }

        private synchronized void stopUpdate() {
            this.updateInProgress = false;
            this.updateTerminated = false;
        }
    }

    public static enum ValuesPanelField {
        BINARY0,
        BINARY1,
        BINARY2,
        BINARY3,
        BINARY4,
        BINARY5,
        BINARY6,
        BINARY7,
        BYTE,
        WORD,
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        CHARACTER,
        STRING;

    }
}

