/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client.stub;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.client.XBCatalogServiceClient;
import org.exbin.xbup.client.catalog.remote.XBRBlockCons;
import org.exbin.xbup.client.catalog.remote.XBRBlockJoin;
import org.exbin.xbup.client.catalog.remote.XBRBlockListCons;
import org.exbin.xbup.client.catalog.remote.XBRBlockListJoin;
import org.exbin.xbup.client.catalog.remote.XBRBlockSpec;
import org.exbin.xbup.client.catalog.remote.XBRFormatCons;
import org.exbin.xbup.client.catalog.remote.XBRFormatJoin;
import org.exbin.xbup.client.catalog.remote.XBRFormatSpec;
import org.exbin.xbup.client.catalog.remote.XBRGroupCons;
import org.exbin.xbup.client.catalog.remote.XBRGroupJoin;
import org.exbin.xbup.client.catalog.remote.XBRGroupSpec;
import org.exbin.xbup.client.catalog.remote.XBRRev;
import org.exbin.xbup.client.catalog.remote.XBRSpec;
import org.exbin.xbup.client.catalog.remote.XBRSpecDef;
import org.exbin.xbup.client.stub.XBPBaseProcedureType;
import org.exbin.xbup.client.stub.XBPBaseStub;
import org.exbin.xbup.client.stub.XBPItemStub;
import org.exbin.xbup.client.stub.XBPStubUtils;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCFormatSpec;
import org.exbin.xbup.core.catalog.base.XBCGroupSpec;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCSpecDef;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.remote.XBCallHandler;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

@ParametersAreNonnullByDefault
public class XBPSpecStub
extends XBPBaseStub<XBCSpec> {
    public static long[] SPEC_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 4L, 0L};
    public static long[] SPECS_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 5L, 0L};
    public static long[] FORMATSPEC_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 6L, 0L};
    public static long[] FORMATSPECS_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 7L, 0L};
    public static long[] GROUPSPEC_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 8L, 0L};
    public static long[] GROUPSPECS_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 9L, 0L};
    public static long[] BLOCKSPEC_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 10L, 0L};
    public static long[] BLOCKSPECS_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 11L, 0L};
    public static long[] FINDBLOCKSPEC_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 16L, 0L};
    public static long[] MAXBLOCKSPEC_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 17L, 0L};
    public static long[] FINDGROUPSPEC_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 18L, 0L};
    public static long[] MAXGROUPSPEC_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 19L, 0L};
    public static long[] FINDFORMATSPEC_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 20L, 0L};
    public static long[] MAXFORMATSPEC_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 21L, 0L};
    public static long[] SPECSCOUNT_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 22L, 0L};
    public static long[] BLOCKSPECSCOUNT_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 23L, 0L};
    public static long[] GROUPSPECSCOUNT_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 24L, 0L};
    public static long[] FORMATSPECSCOUNT_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 25L, 0L};
    public static long[] BIND_SPEC_PROCEDURE = new long[]{0L, 2L, 5L, 0L, 0L};
    public static long[] BINDS_SPEC_PROCEDURE = new long[]{0L, 2L, 5L, 1L, 0L};
    public static long[] BINDSCOUNT_SPEC_PROCEDURE = new long[]{0L, 2L, 5L, 2L, 0L};
    public static long[] FINDBIND_SPEC_PROCEDURE = new long[]{0L, 2L, 5L, 3L, 0L};
    public static long[] FORMATSPECSCOUNT_SPEC_PROCEDURE = new long[]{0L, 2L, 5L, 5L, 0L};
    public static long[] GROUPSPECSCOUNT_SPEC_PROCEDURE = new long[]{0L, 2L, 5L, 6L, 0L};
    public static long[] BLOCKSPECSCOUNT_SPEC_PROCEDURE = new long[]{0L, 2L, 5L, 7L, 0L};
    public static long[] SPECSCOUNT_SPEC_PROCEDURE = new long[]{0L, 2L, 5L, 8L, 0L};
    public static long[] TARGET_BIND_PROCEDURE = new long[]{0L, 2L, 6L, 0L, 0L};
    public static long[] BINDSCOUNT_BIND_PROCEDURE = new long[]{0L, 2L, 6L, 1L, 0L};
    private final XBCatalogServiceClient client;

    public XBPSpecStub(XBCatalogServiceClient client) {
        super(client, XBRSpec::new, new XBPBaseProcedureType(null, null, null, null, (XBBlockType)new XBDeclBlockType(SPECSCOUNT_SPEC_PROCEDURE)));
        this.client = client;
    }

    public XBRRev getTarget(long specDefId) {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(TARGET_BIND_PROCEDURE));
            serialInput.putAttribute(specDefId);
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            UBNat32 target = new UBNat32();
            serialOutput.process((XBSerializable)target);
            procedureCall.execute();
            return target.isZero() ? null : new XBRRev(this.client, target.getLong());
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPItemStub.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Long getAllSpecsCount() {
        return XBPStubUtils.voidToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(SPECSCOUNT_SPEC_PROCEDURE));
    }

    public Long getAllFormatSpecsCount() {
        return XBPStubUtils.voidToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(FORMATSPECSCOUNT_SPEC_PROCEDURE));
    }

    public Long getAllGroupSpecsCount() {
        return XBPStubUtils.voidToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(GROUPSPECSCOUNT_SPEC_PROCEDURE));
    }

    public Long getAllBlockSpecsCount() {
        return XBPStubUtils.voidToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(BLOCKSPECSCOUNT_SPEC_PROCEDURE));
    }

    public Long[] getSpecXBPath(XBCSpec node) {
        ArrayList<Long> list = new ArrayList<Long>();
        XBCNode parent = node.getParent();
        while (parent != null) {
            if (parent.getParent().isPresent()) {
                list.add(0, parent.getXBIndex());
            }
            parent = parent.getParent().orElse(null);
        }
        list.add(node.getXBIndex());
        return list.toArray(new Long[list.size()]);
    }

    public List<XBCSpec> getSpecs(XBCNode node) {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(SPECS_NODE_PROCEDURE));
            serialInput.putAttribute(node.getId());
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            if (!serialOutput.pullIfEmptyBlock()) {
                serialOutput.begin();
                serialOutput.matchType();
                long count = serialOutput.pullLongAttribute();
                ArrayList<XBCSpec> result = new ArrayList<XBCSpec>();
                int i = 0;
                while ((long)i < count) {
                    result.add(new XBRSpec(this.client, serialOutput.pullLongAttribute()));
                    ++i;
                }
                serialOutput.end();
                procedureCall.execute();
                return result;
            }
            procedureCall.execute();
            return null;
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPItemStub.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public XBRSpec getSpec(XBCNode node, long orderIndex) {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(SPEC_NODE_PROCEDURE));
            serialInput.putAttribute(node.getId());
            serialInput.putAttribute(orderIndex);
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            UBNat32 index = new UBNat32();
            serialOutput.process((XBSerializable)index);
            procedureCall.execute();
            return new XBRSpec(this.client, index.getLong());
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPSpecStub.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public XBRFormatSpec getFormatSpec(XBCNode node, long orderIndex) {
        Long index = XBPStubUtils.twoLongsToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(FORMATSPEC_NODE_PROCEDURE), node.getId(), orderIndex);
        return index == null ? null : new XBRFormatSpec(this.client, index);
    }

    public XBRGroupSpec getGroupSpec(XBCNode node, long orderIndex) {
        Long index = XBPStubUtils.twoLongsToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(GROUPSPEC_NODE_PROCEDURE), node.getId(), orderIndex);
        return index == null ? null : new XBRGroupSpec(this.client, index);
    }

    public XBRBlockSpec getBlockSpec(XBCNode node, long orderIndex) {
        Long index = XBPStubUtils.twoLongsToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(BLOCKSPEC_NODE_PROCEDURE), node.getId(), orderIndex);
        return index == null ? null : new XBRBlockSpec(this.client, index);
    }

    public List<XBCFormatSpec> getFormatSpecs(XBCNode node) {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(FORMATSPECS_NODE_PROCEDURE));
            serialInput.putAttribute(node.getId());
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            if (!serialOutput.pullIfEmptyBlock()) {
                serialOutput.begin();
                serialOutput.matchType();
                long count = serialOutput.pullLongAttribute();
                ArrayList<XBCFormatSpec> result = new ArrayList<XBCFormatSpec>();
                int i = 0;
                while ((long)i < count) {
                    result.add(new XBRFormatSpec(this.client, serialOutput.pullLongAttribute()));
                    ++i;
                }
                serialOutput.end();
                procedureCall.execute();
                return result;
            }
            procedureCall.execute();
            return null;
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPItemStub.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public List<XBCGroupSpec> getGroupSpecs(XBCNode node) {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(GROUPSPECS_NODE_PROCEDURE));
            serialInput.putAttribute(node.getId());
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            if (!serialOutput.pullIfEmptyBlock()) {
                serialOutput.begin();
                serialOutput.matchType();
                long count = serialOutput.pullLongAttribute();
                ArrayList<XBCGroupSpec> result = new ArrayList<XBCGroupSpec>();
                int i = 0;
                while ((long)i < count) {
                    result.add(new XBRGroupSpec(this.client, serialOutput.pullLongAttribute()));
                    ++i;
                }
                serialOutput.end();
                procedureCall.execute();
                return result;
            }
            procedureCall.execute();
            return null;
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPItemStub.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public List<XBCBlockSpec> getBlockSpecs(XBCNode node) {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(BLOCKSPECS_NODE_PROCEDURE));
            serialInput.putAttribute(node.getId());
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            if (!serialOutput.pullIfEmptyBlock()) {
                serialOutput.begin();
                serialOutput.matchType();
                long count = serialOutput.pullLongAttribute();
                ArrayList<XBCBlockSpec> result = new ArrayList<XBCBlockSpec>();
                int i = 0;
                while ((long)i < count) {
                    result.add(new XBRBlockSpec(this.client, serialOutput.pullLongAttribute()));
                    ++i;
                }
                serialOutput.end();
                procedureCall.execute();
                return result;
            }
            procedureCall.execute();
            return null;
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPItemStub.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public XBRFormatSpec findFormatSpecByXB(XBCNode node, long xbIndex) {
        Long index = XBPStubUtils.twoLongsToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(FINDFORMATSPEC_NODE_PROCEDURE), node.getId(), xbIndex);
        return index == null ? null : new XBRFormatSpec(this.client, index);
    }

    public XBRGroupSpec findGroupSpecByXB(XBCNode node, long xbIndex) {
        Long index = XBPStubUtils.twoLongsToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(FINDGROUPSPEC_NODE_PROCEDURE), node.getId(), xbIndex);
        return index == null ? null : new XBRGroupSpec(this.client, index);
    }

    public XBRBlockSpec findBlockSpecByXB(XBCNode node, long xbIndex) {
        Long index = XBPStubUtils.twoLongsToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(FINDBLOCKSPEC_NODE_PROCEDURE), node.getId(), xbIndex);
        return index == null ? null : new XBRBlockSpec(this.client, index);
    }

    public Long findMaxFormatSpecXB(XBCNode node) {
        return XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(MAXFORMATSPEC_NODE_PROCEDURE), node.getId());
    }

    public Long findMaxGroupSpecXB(XBCNode node) {
        return XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(MAXGROUPSPEC_NODE_PROCEDURE), node.getId());
    }

    public Long findMaxBlockSpecXB(XBCNode node) {
        return XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(MAXBLOCKSPEC_NODE_PROCEDURE), node.getId());
    }

    public long getFormatSpecsCount(XBCNode node) {
        return XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(FORMATSPECSCOUNT_NODE_PROCEDURE), node.getId());
    }

    public long getGroupSpecsCount(XBCNode node) {
        return XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(GROUPSPECSCOUNT_NODE_PROCEDURE), node.getId());
    }

    public long getBlockSpecsCount(XBCNode node) {
        return XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(BLOCKSPECSCOUNT_NODE_PROCEDURE), node.getId());
    }

    public long getSpecsCount(XBCNode node) {
        return XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(SPECSCOUNT_NODE_PROCEDURE), node.getId());
    }

    public long getDefsCount() {
        return XBPStubUtils.voidToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(BINDSCOUNT_BIND_PROCEDURE));
    }

    public XBRSpecDef getSpecDefByOrder(XBCSpec spec, long orderIndex) {
        block11: {
            try {
                XBCallHandler procedureCall = this.client.procedureCall();
                XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
                serialInput.begin();
                serialInput.putType((XBBlockType)new XBDeclBlockType(BIND_SPEC_PROCEDURE));
                serialInput.putAttribute(spec.getId());
                serialInput.putAttribute(orderIndex);
                serialInput.end();
                XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
                serialOutput.begin();
                serialOutput.matchType();
                long index = serialOutput.pullLongAttribute();
                int bindType = serialOutput.pullIntAttribute();
                serialOutput.end();
                procedureCall.execute();
                if (spec instanceof XBCFormatSpec) {
                    return bindType == 0 ? new XBRFormatCons(this.client, index) : new XBRFormatJoin(this.client, index);
                }
                if (spec instanceof XBCGroupSpec) {
                    return bindType == 0 ? new XBRGroupCons(this.client, index) : new XBRGroupJoin(this.client, index);
                }
                if (spec instanceof XBCBlockSpec) {
                    switch (bindType) {
                        case 0: {
                            return new XBRBlockCons(this.client, index);
                        }
                        case 1: {
                            return new XBRBlockJoin(this.client, index);
                        }
                        case 2: {
                            return new XBRBlockListCons(this.client, index);
                        }
                        case 3: {
                            return new XBRBlockListJoin(this.client, index);
                        }
                    }
                    break block11;
                }
                return new XBRSpecDef(this.client, index);
            }
            catch (IOException | XBProcessingException ex) {
                Logger.getLogger(XBPSpecStub.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public XBRSpecDef findSpecDefByXB(XBCSpec spec, long xbIndex) {
        block11: {
            try {
                XBCallHandler procedureCall = this.client.procedureCall();
                XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
                serialInput.begin();
                serialInput.putType((XBBlockType)new XBDeclBlockType(FINDBIND_SPEC_PROCEDURE));
                serialInput.putAttribute(spec.getId());
                serialInput.putAttribute(xbIndex);
                serialInput.end();
                XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
                serialOutput.begin();
                serialOutput.matchType();
                long index = serialOutput.pullLongAttribute();
                int bindType = serialOutput.pullIntAttribute();
                serialOutput.end();
                procedureCall.execute();
                if (spec instanceof XBCFormatSpec) {
                    return bindType == 0 ? new XBRFormatCons(this.client, index) : new XBRFormatJoin(this.client, index);
                }
                if (spec instanceof XBCGroupSpec) {
                    return bindType == 0 ? new XBRGroupCons(this.client, index) : new XBRGroupJoin(this.client, index);
                }
                if (spec instanceof XBCBlockSpec) {
                    switch (bindType) {
                        case 0: {
                            return new XBRBlockCons(this.client, index);
                        }
                        case 1: {
                            return new XBRBlockJoin(this.client, index);
                        }
                        case 2: {
                            return new XBRBlockListCons(this.client, index);
                        }
                        case 3: {
                            return new XBRBlockListJoin(this.client, index);
                        }
                    }
                    break block11;
                }
                return new XBRSpecDef(this.client, index);
            }
            catch (IOException | XBProcessingException ex) {
                Logger.getLogger(XBPSpecStub.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public List<XBCSpecDef> getSpecDefs(XBCSpec spec) {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(BINDS_SPEC_PROCEDURE));
            serialInput.putAttribute(spec.getId());
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            if (!serialOutput.pullIfEmptyBlock()) {
                serialOutput.begin();
                serialOutput.matchType();
                long count = serialOutput.pullLongAttribute();
                ArrayList<XBCSpecDef> result = new ArrayList<XBCSpecDef>();
                int i = 0;
                while ((long)i < count) {
                    result.add(new XBRSpecDef(this.client, serialOutput.pullLongAttribute()));
                    ++i;
                }
                serialOutput.end();
                procedureCall.execute();
                return result;
            }
            procedureCall.execute();
            return null;
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPItemStub.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public long getSpecDefsCount(XBCSpec spec) {
        return XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(BINDSCOUNT_SPEC_PROCEDURE), spec.getId());
    }
}

