/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client.catalog.remote.service;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.client.catalog.XBRCatalog;
import org.exbin.xbup.client.catalog.remote.XBRBlockSpec;
import org.exbin.xbup.client.catalog.remote.XBRFormatSpec;
import org.exbin.xbup.client.catalog.remote.XBRGroupSpec;
import org.exbin.xbup.client.catalog.remote.XBRSpec;
import org.exbin.xbup.client.catalog.remote.XBRSpecDef;
import org.exbin.xbup.client.catalog.remote.manager.XBRSpecManager;
import org.exbin.xbup.client.catalog.remote.service.XBRDefaultService;
import org.exbin.xbup.core.block.declaration.catalog.XBCBlockDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCFormatDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCGroupDecl;
import org.exbin.xbup.core.block.declaration.local.XBLBlockDecl;
import org.exbin.xbup.core.block.declaration.local.XBLFormatDecl;
import org.exbin.xbup.core.block.declaration.local.XBLGroupDecl;
import org.exbin.xbup.core.block.definition.XBParamType;
import org.exbin.xbup.core.catalog.base.XBCBase;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCFormatSpec;
import org.exbin.xbup.core.catalog.base.XBCGroupSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCSpecDef;
import org.exbin.xbup.core.catalog.base.XBCXDesc;
import org.exbin.xbup.core.catalog.base.XBCXHDoc;
import org.exbin.xbup.core.catalog.base.XBCXName;
import org.exbin.xbup.core.catalog.base.XBCXStri;
import org.exbin.xbup.core.catalog.base.manager.XBCSpecManager;
import org.exbin.xbup.core.catalog.base.manager.XBCXDescManager;
import org.exbin.xbup.core.catalog.base.manager.XBCXHDocManager;
import org.exbin.xbup.core.catalog.base.manager.XBCXNameManager;
import org.exbin.xbup.core.catalog.base.manager.XBCXStriManager;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;

@ParametersAreNonnullByDefault
public class XBRSpecService
extends XBRDefaultService<XBCSpec>
implements XBCSpecService {
    public XBRSpecService(XBRCatalog catalog) {
        super(catalog);
        this.itemManager = new XBRSpecManager(catalog);
        catalog.addCatalogManager(XBCSpecManager.class, (XBCSpecManager)this.itemManager);
    }

    public XBRBlockSpec findBlockSpecByXB(XBCNode node, long xbIndex) {
        return ((XBRSpecManager)this.itemManager).findBlockSpecByXB(node, xbIndex);
    }

    public XBRFormatSpec findFormatSpecByXB(XBCNode node, long xbIndex) {
        return ((XBRSpecManager)this.itemManager).findFormatSpecByXB(node, xbIndex);
    }

    public XBRGroupSpec findGroupSpecByXB(XBCNode node, long xbIndex) {
        return ((XBRSpecManager)this.itemManager).findGroupSpecByXB(node, xbIndex);
    }

    public Long findMaxBlockSpecXB(XBCNode node) {
        return ((XBRSpecManager)this.itemManager).findMaxBlockSpecXB(node);
    }

    public Long findMaxFormatSpecXB(XBCNode node) {
        return ((XBRSpecManager)this.itemManager).findMaxFormatSpecXB(node);
    }

    public Long findMaxGroupSpecXB(XBCNode node) {
        return ((XBRSpecManager)this.itemManager).findMaxGroupSpecXB(node);
    }

    public Long getAllBlockSpecsCount() {
        return ((XBRSpecManager)this.itemManager).getAllBlockSpecsCount();
    }

    public Long getAllFormatSpecsCount() {
        return ((XBRSpecManager)this.itemManager).getAllFormatSpecsCount();
    }

    public Long getAllGroupSpecsCount() {
        return ((XBRSpecManager)this.itemManager).getAllGroupSpecsCount();
    }

    public Long getAllSpecsCount() {
        return ((XBRSpecManager)this.itemManager).getAllSpecsCount();
    }

    public XBRBlockSpec getBlockSpec(XBCNode node, long index) {
        return ((XBRSpecManager)this.itemManager).getBlockSpec(node, index);
    }

    public List<XBCBlockSpec> getBlockSpecs(XBCNode node) {
        return ((XBRSpecManager)this.itemManager).getBlockSpecs(node);
    }

    public long getBlockSpecsCount(XBCNode node) {
        return ((XBRSpecManager)this.itemManager).getBlockSpecsCount(node);
    }

    public XBRFormatSpec getFormatSpec(XBCNode node, long index) {
        return ((XBRSpecManager)this.itemManager).getFormatSpec(node, index);
    }

    public List<XBCFormatSpec> getFormatSpecs(XBCNode node) {
        return ((XBRSpecManager)this.itemManager).getFormatSpecs(node);
    }

    public long getFormatSpecsCount(XBCNode node) {
        return ((XBRSpecManager)this.itemManager).getFormatSpecsCount(node);
    }

    public XBRGroupSpec getGroupSpec(XBCNode node, long index) {
        return ((XBRSpecManager)this.itemManager).getGroupSpec(node, index);
    }

    public List<XBCGroupSpec> getGroupSpecs(XBCNode node) {
        return ((XBRSpecManager)this.itemManager).getGroupSpecs(node);
    }

    public long getGroupSpecsCount(XBCNode node) {
        return ((XBRSpecManager)this.itemManager).getGroupSpecsCount(node);
    }

    public XBRSpec getSpecByOrder(XBCNode node, long index) {
        return ((XBRSpecManager)this.itemManager).getSpec(node, index);
    }

    public Long[] getSpecXBPath(XBCSpec spec) {
        return ((XBRSpecManager)this.itemManager).getSpecXBPath(spec);
    }

    public List<XBCSpec> getSpecs(XBCNode node) {
        return ((XBRSpecManager)this.itemManager).getSpecs(node);
    }

    public long getSpecsCount(XBCNode node) {
        return ((XBRSpecManager)this.itemManager).getSpecsCount(node);
    }

    public XBRSpecDef findSpecDefByXB(XBCSpec spec, long xbIndex) {
        return ((XBRSpecManager)this.itemManager).findSpecDefByXB(spec, xbIndex);
    }

    public Long findMaxSpecDefXB(XBCSpec spec) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public XBRSpecDef getSpecDefByOrder(XBCSpec spec, long index) {
        return ((XBRSpecManager)this.itemManager).getSpecDefByOrder(spec, index);
    }

    public List<XBCSpecDef> getSpecDefs(XBCSpec spec) {
        return ((XBRSpecManager)this.itemManager).getSpecDefs(spec);
    }

    public long getSpecDefsCount(XBCSpec spec) {
        return ((XBRSpecManager)this.itemManager).getSpecDefsCount(spec);
    }

    public long getDefsCount() {
        return ((XBRSpecManager)this.itemManager).getDefsCount();
    }

    public XBCSpecDef getSpecDef(long itemId) {
        return ((XBRSpecManager)this.itemManager).getSpecDef(itemId);
    }

    public XBCSpecDef createSpecDef(XBCSpec spec, XBParamType type) {
        return ((XBRSpecManager)this.itemManager).createSpecDef(spec, type);
    }

    public XBCBlockSpec createBlockSpec() {
        return ((XBRSpecManager)this.itemManager).createBlockSpec();
    }

    public XBCGroupSpec createGroupSpec() {
        return ((XBRSpecManager)this.itemManager).createGroupSpec();
    }

    public XBCFormatSpec createFormatSpec() {
        return ((XBRSpecManager)this.itemManager).createFormatSpec();
    }

    public void removeItemDepth(XBCSpecDef specDef) {
        XBCXHDocManager hdocManager;
        XBCXHDoc itemHDoc;
        XBCXNameManager nameManager = this.catalog.getCatalogManager(XBCXNameManager.class);
        List itemNames = nameManager.getItemNames((XBCItem)specDef);
        for (XBCXName itemName : itemNames) {
            nameManager.removeItem((XBCBase)itemName);
        }
        XBCXDescManager descManager = this.catalog.getCatalogManager(XBCXDescManager.class);
        List itemDescs = descManager.getItemDescs((XBCItem)specDef);
        for (XBCXDesc itemDesc : itemDescs) {
            descManager.removeItem((XBCBase)itemDesc);
        }
        XBCXStriManager striManager = this.catalog.getCatalogManager(XBCXStriManager.class);
        XBCXStri itemStri = striManager.getItemStringId((XBCItem)specDef);
        if (itemStri != null) {
            striManager.removeItem((XBCBase)itemStri);
        }
        if ((itemHDoc = (hdocManager = this.catalog.getCatalogManager(XBCXHDocManager.class)).getDocumentation((XBCItem)specDef)) != null) {
            hdocManager.removeItem((XBCBase)itemHDoc);
        }
        this.removeSpecDef(specDef);
    }

    public XBLFormatDecl getFormatDeclAsLocal(XBCFormatDecl formatDecl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public XBLGroupDecl getGroupDeclAsLocal(XBCGroupDecl groupDecl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public XBLBlockDecl getBlockDeclAsLocal(XBCBlockDecl blockDecl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void persistSpecDef(XBCSpecDef specDef) {
        ((XBRSpecManager)this.itemManager).persistSpecDef(specDef);
    }

    public void removeSpecDef(XBCSpecDef specDef) {
        ((XBRSpecManager)this.itemManager).removeSpecDef(specDef);
    }
}

