/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.parser_command;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.xbup.core.block.XBBlock;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBDefaultEditableBlock;
import org.exbin.xbup.core.block.XBEditableBlock;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.parser_command.XBCommandBlock;
import org.exbin.xbup.parser_command.XBReaderBlock;
import org.exbin.xbup.parser_command.XBWriter;

public class XBWriterBlock
implements XBCommandBlock,
XBEditableBlock,
Closeable {
    private long blockId = 0L;
    private final long[] blockPath;
    private final XBWriter writer;
    private XBDefaultEditableBlock fixedBlock = null;

    public XBWriterBlock(XBWriter writer, long[] blockPath, long blockId) {
        this.blockId = blockId;
        this.blockPath = blockPath;
        this.writer = writer;
    }

    public long getBlockId() {
        return this.blockId;
    }

    public boolean isFixedBlock() {
        return this.fixedBlock != null;
    }

    @Nonnull
    public Optional<XBBlock> getParentBlock() {
        if (this.blockPath.length == 0) {
            return Optional.empty();
        }
        return this.writer.getBlock(Arrays.copyOf(this.blockPath, this.blockPath.length - 1));
    }

    public boolean equals(Object obj) {
        if (obj instanceof XBReaderBlock) {
            Arrays.equals(((XBReaderBlock)obj).getBlockPath(), this.blockPath);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Arrays.hashCode(this.blockPath);
        return hash;
    }

    @Override
    public long[] getBlockPath() {
        return this.blockPath;
    }

    public XBBlockDataMode getDataMode() {
        if (this.fixedBlock != null) {
            return this.fixedBlock.getDataMode();
        }
        try {
            this.writer.seekBlock(this);
            return this.writer.getBlockDataMode();
        }
        catch (IOException | XBProcessingException ex) {
            return null;
        }
    }

    public XBBlockTerminationMode getTerminationMode() {
        if (this.fixedBlock != null) {
            return this.fixedBlock.getTerminationMode();
        }
        try {
            this.writer.seekBlock(this);
            return this.writer.getBlockTerminationMode();
        }
        catch (IOException | XBProcessingException ex) {
            return null;
        }
    }

    public XBAttribute[] getAttributes() {
        XBAttribute blockAttribute;
        if (this.fixedBlock != null) {
            return this.fixedBlock.getAttributes();
        }
        try {
            this.writer.seekBlock(this);
        }
        catch (IOException | XBProcessingException ex) {
            return null;
        }
        ArrayList<XBAttribute> attributes = new ArrayList<XBAttribute>();
        int attributeIndex = 0;
        do {
            try {
                blockAttribute = this.writer.getBlockAttribute(attributeIndex);
            }
            catch (IOException | XBProcessingException ex) {
                blockAttribute = null;
            }
            if (blockAttribute == null) continue;
            attributes.add(blockAttribute);
            ++attributeIndex;
        } while (blockAttribute != null);
        return attributes.toArray(new XBAttribute[0]);
    }

    public XBAttribute getAttributeAt(int attributeIndex) {
        if (this.fixedBlock != null) {
            return this.fixedBlock.getAttributeAt(attributeIndex);
        }
        try {
            this.writer.seekBlock(this);
        }
        catch (IOException | XBProcessingException ex) {
            return null;
        }
        XBAttribute blockAttribute = null;
        try {
            blockAttribute = this.writer.getBlockAttribute(attributeIndex);
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBReaderBlock.class.getName()).log(Level.SEVERE, null, ex);
        }
        return blockAttribute == null ? null : blockAttribute.convertToNatural();
    }

    public int getAttributesCount() {
        if (this.fixedBlock != null) {
            return this.fixedBlock.getAttributesCount();
        }
        try {
            this.writer.seekBlock(this);
            return this.writer.getBlockAttributesCount();
        }
        catch (IOException | XBProcessingException ex) {
            return 0;
        }
    }

    public XBBlock[] getChildren() {
        if (this.fixedBlock != null) {
            return this.fixedBlock.getChildren();
        }
        int childrenCount = this.getChildrenCount();
        XBBlock[] result = new XBBlock[childrenCount];
        for (int i = 0; i < result.length; ++i) {
            long[] childPath = Arrays.copyOf(this.blockPath, this.blockPath.length + 1);
            childPath[childPath.length - 1] = i;
            result[i] = this.writer.getBlock(childPath).get();
        }
        return result;
    }

    public XBBlock getChildAt(int childIndex) {
        if (this.fixedBlock != null) {
            return this.fixedBlock.getChildAt(childIndex);
        }
        try {
            if (this.writer.hasBlockChildAt(childIndex)) {
                return this.writer.getBlockChild(this, childIndex);
            }
        }
        catch (IOException | XBProcessingException throwable) {
            // empty catch block
        }
        return null;
    }

    public int getChildrenCount() {
        if (this.fixedBlock != null) {
            return this.fixedBlock.getChildrenCount();
        }
        try {
            this.writer.seekBlock(this);
            return this.writer.getBlockChildrenCount();
        }
        catch (IOException | XBProcessingException ex) {
            return 0;
        }
    }

    @Nonnull
    public InputStream getData() {
        if (this.fixedBlock != null) {
            return this.fixedBlock.getData();
        }
        try {
            this.writer.seekBlock(this);
            return this.writer.getBlockData();
        }
        catch (IOException | XBProcessingException ex) {
            throw new IllegalStateException("Unable to process data");
        }
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Nonnull
    public BinaryData getBlockData() {
        if (this.fixedBlock != null) {
            return this.fixedBlock.getBlockData();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setParent(XBBlock parent) {
        if (this.fixedBlock == null) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.fixedBlock.setParent(parent);
    }

    public void setTerminationMode(XBBlockTerminationMode terminationMode) {
        if (!this.isFixedBlock()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.fixedBlock.setTerminationMode(terminationMode);
    }

    public void setDataMode(XBBlockDataMode dataMode) {
        if (!this.isFixedBlock()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.fixedBlock.setDataMode(dataMode);
    }

    public void setAttributes(XBAttribute[] attributes) {
        if (!this.isFixedBlock()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.fixedBlock.setAttributes(attributes);
    }

    public void setAttributeAt(XBAttribute attribute, int attributeIndex) {
        if (!this.isFixedBlock()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.fixedBlock.setAttributeAt(attribute, attributeIndex);
    }

    public void setAttributesCount(int count) {
        if (!this.isFixedBlock()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.fixedBlock.setAttributesCount(count);
    }

    public void removeAttribute(int attributeIndex) {
        if (!this.isFixedBlock()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.fixedBlock.removeAttribute(attributeIndex);
    }

    public void setChildren(XBBlock[] blocks) {
        if (!this.isFixedBlock()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.fixedBlock.setChildren(blocks);
    }

    public void setChildAt(XBBlock block, int childIndex) {
        if (!this.isFixedBlock()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.fixedBlock.setChildAt(block, childIndex);
    }

    public void setChildrenCount(int count) {
        if (!this.isFixedBlock()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.fixedBlock.setChildrenCount(count);
    }

    public XBBlock createNewChild(int childIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeChild(int childIndex) {
        if (!this.isFixedBlock()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.fixedBlock.removeChild(childIndex);
    }

    public void setData(InputStream data) throws IOException {
        if (!this.isFixedBlock()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.fixedBlock.setData(data);
    }

    public void setData(BinaryData data) {
        if (!this.isFixedBlock()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.fixedBlock.setData(data);
    }

    public void clear() {
        if (!this.isFixedBlock()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.fixedBlock.clear();
    }

    public void setFixedBlock(XBBlock block) {
        if (this.fixedBlock == null) {
            this.fixedBlock = new XBDefaultEditableBlock();
        }
        this.fixedBlock.setTerminationMode(block.getTerminationMode());
        XBBlockDataMode dataMode = block.getDataMode();
        this.fixedBlock.setDataMode(dataMode);
        if (dataMode == XBBlockDataMode.NODE_BLOCK) {
            this.fixedBlock.setAttributes(block.getAttributes());
            XBBlock[] children = block.getChildren();
            if (children.length > 0) {
                XBBlock[] modifiedChildren = new XBBlock[children.length];
                for (int i = 0; i < children.length; ++i) {
                    XBWriterBlock modifiedChild = this.writer.createChildBlock(this.blockPath, i);
                    modifiedChild.setFixedBlock(children[i]);
                    modifiedChildren[i] = modifiedChild;
                }
                this.fixedBlock.setChildren(modifiedChildren);
            }
        } else {
            this.fixedBlock.setData(block.getBlockData());
        }
    }
}

