/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.parser_command;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.xbup.core.block.XBBlock;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBDefaultDocument;
import org.exbin.xbup.core.block.XBDocument;
import org.exbin.xbup.core.block.XBEditableBlock;
import org.exbin.xbup.core.parser.XBParserMode;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.basic.XBListener;
import org.exbin.xbup.core.parser.basic.XBProvider;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.parser.token.XBToken;
import org.exbin.xbup.core.parser.token.XBTokenType;
import org.exbin.xbup.core.parser.token.convert.XBListenerToToken;
import org.exbin.xbup.core.parser.token.pull.XBPullProvider;
import org.exbin.xbup.core.parser.token.pull.XBPullWriter;
import org.exbin.xbup.core.parser.token.pull.convert.XBProviderToPullProvider;
import org.exbin.xbup.core.stream.SeekableStream;
import org.exbin.xbup.core.type.XBData;
import org.exbin.xbup.parser_command.XBCommandWriter;
import org.exbin.xbup.parser_command.XBReader;
import org.exbin.xbup.parser_command.XBWriterBlock;
import org.exbin.xbup.parser_tree.XBTreeWriter;

public class XBWriter
implements XBCommandWriter,
XBPullProvider,
Closeable {
    private InputStream inputStream;
    private OutputStream outputStream;
    private XBReader reader;
    private BinaryData tailData = null;
    private XBTreeWriter treeWriter = null;
    private long activeBlockId = 0L;
    private long blockStoreIndex = 1L;
    private final Map<Long, XBWriterBlock> blockStore = new HashMap<Long, XBWriterBlock>();
    private BlockTreeCache blockTreeCache = null;

    public XBWriter() {
        this.reader = new XBReader();
        this.reset();
    }

    public XBWriter(InputStream inputStream, OutputStream outputStream) {
        this(inputStream, outputStream, XBParserMode.FULL);
    }

    public XBWriter(InputStream inputStream, OutputStream outputStream, XBParserMode parserMode) {
        if (!(inputStream instanceof SeekableStream) && !(outputStream instanceof SeekableStream)) {
            throw new IllegalArgumentException("XBWriter only supports seekable streams");
        }
        this.reader = new XBReader(inputStream, parserMode);
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.reset();
    }

    @Override
    public void open(InputStream stream) throws IOException {
        this.reader.open(stream);
    }

    @Override
    public void save(OutputStream stream) throws IOException {
        this.outputStream = stream;
        try (XBPullWriter pullWriter = new XBPullWriter(this.outputStream);){
            if (this.treeWriter == null) {
                XBWriterBlock activeBlock = this.getActiveBlock();
                this.treeWriter = activeBlock == null ? new XBTreeWriter((XBDocument)new XBDefaultDocument(this.getRootBlock().get(), (InputStream)this.getTailData().orElse(null))) : new XBTreeWriter((XBBlock)activeBlock);
            }
            XBProviderToPullProvider pullProvider = new XBProviderToPullProvider((XBProvider)this.treeWriter);
            pullWriter.attachXBPullProvider((XBPullProvider)pullProvider);
            pullWriter.write();
        }
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Nonnull
    public Optional<XBBlock> getRootBlock() {
        return this.getBlock(new long[0]);
    }

    @Override
    @Nonnull
    public Optional<XBBlock> getBlock(long[] blockPath) {
        BlockTreeCache cacheNode = this.blockTreeCache;
        if (cacheNode != null && blockPath.length == 0) {
            return Optional.of(cacheNode.block);
        }
        int depth = 0;
        while (cacheNode != null && depth < blockPath.length && cacheNode.childBlocks != null) {
            cacheNode = cacheNode.childBlocks.get((int)blockPath[depth]);
            if (cacheNode == null || ++depth != blockPath.length || cacheNode.block == null) continue;
            return Optional.of(cacheNode.block);
        }
        return Optional.of(this.createNewBlock(blockPath));
    }

    public XBEditableBlock getBlockChild(XBWriterBlock parentBlock, int childIndex) {
        long[] blockPath = parentBlock.getBlockPath();
        long[] childPath = Arrays.copyOf(blockPath, blockPath.length + 1);
        childPath[childPath.length - 1] = childIndex;
        return this.createNewBlock(childPath);
    }

    @Nonnull
    private XBWriterBlock createNewBlock(long[] blockPath) {
        ++this.blockStoreIndex;
        XBWriterBlock block = new XBWriterBlock(this, blockPath, this.blockStoreIndex);
        this.blockStore.put(this.blockStoreIndex, block);
        BlockTreeCache cacheNode = this.blockTreeCache;
        if (cacheNode == null) {
            this.blockTreeCache = cacheNode = new BlockTreeCache();
        }
        for (int depth = 0; depth < blockPath.length; ++depth) {
            BlockTreeCache childNode;
            if (cacheNode.childBlocks == null) {
                cacheNode.childBlocks = new HashMap<Integer, BlockTreeCache>();
            }
            if ((childNode = cacheNode.childBlocks.get((int)blockPath[depth])) == null) {
                childNode = new BlockTreeCache();
                cacheNode.childBlocks.put((int)blockPath[depth], childNode);
            }
            cacheNode = childNode;
        }
        cacheNode.block = block;
        return block;
    }

    @Override
    public void resetXB() throws IOException {
        this.reset();
    }

    private void reset() {
    }

    @Override
    public void flush() {
    }

    public void seekBlock(XBWriterBlock targetBlock) throws XBProcessingException, IOException {
        this.setActiveBlockId(targetBlock);
        if (!targetBlock.isFixedBlock()) {
            this.reader.seekBlock(targetBlock);
        }
    }

    public XBToken pullXBToken() throws XBProcessingException, IOException {
        XBToken token;
        XBWriterBlock block;
        if (this.activeBlockId == 0L) {
            block = this.getRootBlock().orElse(null);
            this.setActiveBlockId(block);
        } else {
            block = this.getActiveBlock();
        }
        if (block.isFixedBlock()) {
            if (this.treeWriter == null) {
                this.treeWriter = new XBTreeWriter((XBBlock)block);
            }
            XBListenerToToken tokenListener = new XBListenerToToken();
            this.treeWriter.produceXB((XBListener)tokenListener, false);
            XBToken token2 = tokenListener.getToken();
            if (token2.getTokenType() == XBTokenType.END && block.getDataMode() == XBBlockDataMode.NODE_BLOCK) {
                XBWriterBlock childBlock = (XBWriterBlock)block.getChildAt(0);
                if (childBlock == null) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
                this.setActiveBlockId(childBlock);
                return this.pullXBToken();
            }
            return token2;
        }
        boolean postSeek = false;
        if (this.reader.getActiveBlock() != block) {
            this.seekBlock(block);
            postSeek = true;
        }
        if ((token = this.reader.pullXBToken()).getTokenType() == XBTokenType.BEGIN && this.reader.getActiveBlock() != block) {
            if (postSeek) {
                this.reader.setActiveBlock(block);
            } else {
                XBWriterBlock nextBlock = (XBWriterBlock)this.reader.getActiveBlock();
                if (nextBlock == null) {
                    nextBlock = this.getBlock(this.reader.getCurrentBlockPath()).orElse(null);
                    this.reader.setActiveBlock(nextBlock);
                }
                this.setActiveBlockId(nextBlock);
            }
        } else if (token.getTokenType() == XBTokenType.END) {
            XBWriterBlock nextBlock = this.getActiveBlock().getParentBlock().orElse(null);
            this.reader.setActiveBlock(nextBlock);
            this.setActiveBlockId(nextBlock);
        }
        return token;
    }

    public boolean isFinishedXB() {
        return this.reader.isFinishedXB();
    }

    public XBBlockDataMode getBlockDataMode() throws XBProcessingException, IOException {
        return this.reader.getBlockDataMode();
    }

    public XBBlockTerminationMode getBlockTerminationMode() throws XBProcessingException, IOException {
        return this.reader.getBlockTerminationMode();
    }

    public XBAttribute getBlockAttribute(int attributeIndex) throws XBProcessingException, IOException {
        return this.reader.getBlockAttribute(attributeIndex);
    }

    public int getBlockAttributesCount() throws XBProcessingException, IOException {
        return this.reader.getBlockAttributesCount();
    }

    @Nonnull
    public InputStream getBlockData() throws XBProcessingException, IOException {
        return this.reader.getBlockData();
    }

    public int getBlockChildrenCount() throws XBProcessingException, IOException {
        return this.reader.getBlockChildrenCount();
    }

    public boolean hasBlockChildAt(int childIndex) throws XBProcessingException, IOException {
        return this.reader.hasBlockChildAt(childIndex);
    }

    public long[] getCurrentPath() {
        return this.reader.getCurrentBlockPath();
    }

    @Nonnull
    public Optional<InputStream> getTailData() {
        Optional<XBBlock> rootBlock = this.getRootBlock();
        if (rootBlock.isPresent() && ((XBWriterBlock)rootBlock.get()).isFixedBlock()) {
            return this.tailData == null ? Optional.of(new XBData().getDataInputStream()) : Optional.of(this.tailData.getDataInputStream());
        }
        return this.reader.getTailData();
    }

    public long getTailDataSize() {
        Optional<XBBlock> rootBlock = this.getRootBlock();
        if (rootBlock.isPresent() && ((XBWriterBlock)rootBlock.get()).isFixedBlock()) {
            return this.tailData == null ? -1L : this.tailData.getDataSize();
        }
        return this.reader.getTailDataSize();
    }

    public long getDocumentSize() {
        return this.reader.getDocumentSize();
    }

    public void setRootBlock(XBBlock block) {
        long[] blockPath = new long[]{};
        Optional<XBBlock> optRootBlock = this.getBlock(blockPath);
        XBWriterBlock rootBlock = null;
        rootBlock = optRootBlock.isPresent() ? (XBWriterBlock)optRootBlock.get() : this.createNewBlock(blockPath);
        rootBlock.setFixedBlock(block);
    }

    public void setTailData(InputStream source) throws IOException {
        this.tailData = new XBData();
        ((XBData)this.tailData).loadFromStream(source);
    }

    public void clear() {
        this.tailData = null;
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private XBWriterBlock getActiveBlock() {
        return this.activeBlockId == 0L ? null : this.blockStore.get(this.activeBlockId);
    }

    private void setActiveBlockId(XBWriterBlock block) {
        this.activeBlockId = block == null ? 0L : block.getBlockId();
        this.treeWriter = null;
    }

    public XBWriterBlock createChildBlock(long[] blockPath, int childIndex) {
        long[] childPath = new long[blockPath.length + 1];
        System.arraycopy(blockPath, 0, childPath, 0, blockPath.length);
        childPath[childPath.length - 1] = childIndex;
        return this.createNewBlock(childPath);
    }

    private class BlockTreeCache {
        XBWriterBlock block;
        Map<Integer, BlockTreeCache> childBlocks;

        private BlockTreeCache() {
        }
    }
}

