/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.parser_command;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.xbup.core.block.XBBlock;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.ubnumber.UBNatural;
import org.exbin.xbup.parser_command.XBCommandBlock;
import org.exbin.xbup.parser_command.XBReader;

public class XBReaderBlock
implements XBCommandBlock,
XBBlock,
Closeable {
    private final long[] blockPath;
    private final XBReader reader;

    public XBReaderBlock(XBReader reader, long[] blockPath) {
        this.blockPath = blockPath;
        this.reader = reader;
    }

    @Nonnull
    public Optional<XBBlock> getParentBlock() {
        if (this.blockPath.length == 0) {
            return Optional.empty();
        }
        return this.reader.getBlock(Arrays.copyOf(this.blockPath, this.blockPath.length - 1));
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof XBReaderBlock) {
            Arrays.equals(((XBReaderBlock)obj).blockPath, this.blockPath);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Arrays.hashCode(this.blockPath);
        return hash;
    }

    @Override
    @Nonnull
    public long[] getBlockPath() {
        return this.blockPath;
    }

    @Nonnull
    public XBBlockDataMode getDataMode() {
        try {
            this.reader.seekBlock(this);
            return this.reader.getBlockDataMode();
        }
        catch (IOException | XBProcessingException ex) {
            return null;
        }
    }

    @Nonnull
    public XBBlockTerminationMode getTerminationMode() {
        try {
            this.reader.seekBlock(this);
            return this.reader.getBlockTerminationMode();
        }
        catch (IOException | XBProcessingException ex) {
            return null;
        }
    }

    public XBAttribute[] getAttributes() {
        XBAttribute blockAttribute;
        try {
            this.reader.seekBlock(this);
        }
        catch (IOException | XBProcessingException ex) {
            return null;
        }
        ArrayList<XBAttribute> attributes = new ArrayList<XBAttribute>();
        int attributeIndex = 0;
        do {
            try {
                blockAttribute = this.reader.getBlockAttribute(attributeIndex);
            }
            catch (IOException | XBProcessingException ex) {
                blockAttribute = null;
            }
            if (blockAttribute == null) continue;
            attributes.add(blockAttribute);
            ++attributeIndex;
        } while (blockAttribute != null);
        return attributes.toArray(new XBAttribute[0]);
    }

    public UBNatural getAttributeAt(int attributeIndex) {
        try {
            this.reader.seekBlock(this);
        }
        catch (IOException | XBProcessingException ex) {
            return null;
        }
        XBAttribute blockAttribute = null;
        try {
            blockAttribute = this.reader.getBlockAttribute(attributeIndex);
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBReaderBlock.class.getName()).log(Level.SEVERE, null, ex);
        }
        return blockAttribute == null ? null : blockAttribute.convertToNatural();
    }

    public int getAttributesCount() {
        try {
            this.reader.seekBlock(this);
            return this.reader.getBlockAttributesCount();
        }
        catch (IOException | XBProcessingException ex) {
            return 0;
        }
    }

    public XBBlock[] getChildren() {
        int childrenCount = this.getChildrenCount();
        XBBlock[] result = new XBBlock[childrenCount];
        for (int i = 0; i < result.length; ++i) {
            long[] childPath = Arrays.copyOf(this.blockPath, this.blockPath.length + 1);
            childPath[childPath.length - 1] = i;
            result[i] = new XBReaderBlock(this.reader, childPath);
        }
        return result;
    }

    public XBBlock getChildAt(int childIndex) {
        try {
            if (this.reader.hasBlockChildAt(childIndex)) {
                long[] childPath = Arrays.copyOf(this.blockPath, this.blockPath.length + 1);
                childPath[childPath.length - 1] = childIndex;
                return new XBReaderBlock(this.reader, childPath);
            }
        }
        catch (IOException | XBProcessingException throwable) {
            // empty catch block
        }
        return null;
    }

    public int getChildrenCount() {
        try {
            this.reader.seekBlock(this);
            return this.reader.getBlockChildrenCount();
        }
        catch (IOException | XBProcessingException ex) {
            return 0;
        }
    }

    public InputStream getData() {
        try {
            this.reader.seekBlock(this);
            return this.reader.getBlockData();
        }
        catch (IOException | XBProcessingException ex) {
            throw new IllegalStateException("Unable to acquire data", ex);
        }
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Nonnull
    public BinaryData getBlockData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

