/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.spec.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.data.model.CatalogDefOperationType;
import org.exbin.framework.data.model.CatalogDefsTableItem;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;
import org.exbin.framework.xbup.catalog.item.gui.CatalogItemType;
import org.exbin.framework.xbup.catalog.item.revision.gui.CatalogSelectRevPanel;
import org.exbin.xbup.core.block.definition.XBParamType;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCFormatSpec;
import org.exbin.xbup.core.catalog.base.XBCGroupSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCRev;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;

@ParametersAreNonnullByDefault
public class CatalogSpecDefEditorPanel
extends JPanel {
    private XBApplication application;
    private XBACatalog catalog;
    private XBCSpec spec;
    private CatalogDefsTableItem defItem;
    private CatalogItemType targetType = CatalogItemType.BLOCK;
    private XBCRev targetRev = null;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CatalogSpecDefEditorPanel.class);
    private JLabel definitionTargetLabel;
    private JTextField definitionTargetTextField;
    private JLabel descriptionLabel;
    private JTextField descriptionTextField;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JComboBox<String> operationComboBox;
    private JLabel operationLabel;
    private JButton selectTargetButton;
    private JLabel stringIdLabel;
    private JTextField stringIdTextField;

    public CatalogSpecDefEditorPanel() {
        this.initComponents();
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    private void initComponents() {
        this.operationLabel = new JLabel();
        this.operationComboBox = new JComboBox();
        this.definitionTargetLabel = new JLabel();
        this.definitionTargetTextField = new JTextField();
        this.selectTargetButton = new JButton();
        this.stringIdLabel = new JLabel();
        this.stringIdTextField = new JTextField();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.descriptionLabel = new JLabel();
        this.descriptionTextField = new JTextField();
        this.operationLabel.setText(this.resourceBundle.getString("operationLabel.text"));
        this.operationComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Consist", "Join"}));
        this.operationComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CatalogSpecDefEditorPanel.this.operationComboBoxItemStateChanged(evt);
            }
        });
        this.definitionTargetLabel.setText("Target Type");
        this.definitionTargetTextField.setEditable(false);
        this.selectTargetButton.setText("Select...");
        this.selectTargetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogSpecDefEditorPanel.this.selectTargetButtonActionPerformed(evt);
            }
        });
        this.stringIdLabel.setText("String Id");
        this.nameLabel.setText("Name");
        this.descriptionLabel.setText("Description");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.operationComboBox, 0, 388, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.definitionTargetTextField, -1, 293, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectTargetButton)).addComponent(this.stringIdTextField).addComponent(this.nameTextField).addComponent(this.descriptionTextField).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.operationLabel).addComponent(this.definitionTargetLabel).addComponent(this.stringIdLabel).addComponent(this.nameLabel).addComponent(this.descriptionLabel)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.operationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.operationComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.definitionTargetLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.definitionTargetTextField, -2, -1, -2).addComponent(this.selectTargetButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stringIdLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stringIdTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descriptionTextField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void operationComboBoxItemStateChanged(ItemEvent evt) {
        this.updateSpecDefType();
    }

    private void selectTargetButtonActionPerformed(ActionEvent evt) {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        CatalogSelectRevPanel panel = new CatalogSelectRevPanel(this.catalog, this.targetType);
        panel.setApplication(this.application);
        DefaultControlPanel controlPanel = new DefaultControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)panel, (JPanel)controlPanel);
        frameModule.setDialogTitle(dialog, panel.getResourceBundle());
        controlPanel.setHandler(actionType -> {
            if (actionType == DefaultControlHandler.ControlActionType.OK) {
                this.setTargetRev(panel.getTarget());
            }
            dialog.close();
        });
        dialog.showCentered((Component)this);
        dialog.dispose();
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogSpecDefEditorPanel());
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    public void setSpec(XBCSpec spec) {
        this.spec = spec;
        if (spec instanceof XBCBlockSpec) {
            this.operationComboBox.setModel(new DefaultComboBoxModel<String>(CatalogDefOperationType.getAsArray()));
            this.switchSpecDefType(CatalogItemType.BLOCK);
        } else {
            this.operationComboBox.setModel(new DefaultComboBoxModel<String>(CatalogDefOperationType.getAsArray((int)2)));
            if (spec instanceof XBCGroupSpec) {
                this.switchSpecDefType(CatalogItemType.BLOCK);
            } else {
                this.switchSpecDefType(CatalogItemType.GROUP);
            }
        }
    }

    public XBACatalog getCatalog() {
        return this.catalog;
    }

    public CatalogDefsTableItem getDefItem() {
        String operationCaption = (String)this.operationComboBox.getModel().getSelectedItem();
        XBCRev target = this.targetRev;
        CatalogDefOperationType operation = this.getOperation();
        if (target == null && this.getOperationRequireTarget(operation)) {
            return null;
        }
        this.defItem.setName(this.nameTextField.getText());
        this.defItem.setDescription(this.descriptionTextField.getText());
        this.defItem.setStringId(this.stringIdTextField.getText());
        this.defItem.setDefType(this.getSpecDefType());
        this.defItem.setOperation(operationCaption);
        this.defItem.setTarget(target);
        XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
        this.defItem.setType(target != null ? nameService.getDefaultText((XBCItem)target.getParent()) : null);
        this.defItem.setTargetRevision(target != null ? Long.valueOf(target.getXBIndex()) : null);
        return this.defItem;
    }

    public void setDefItem(CatalogDefsTableItem defItem) {
        this.defItem = defItem;
        this.nameTextField.setText(defItem.getName());
        this.descriptionTextField.setText(defItem.getDescription());
        this.stringIdTextField.setText(defItem.getStringId());
        if (defItem.getDefType() == null) {
            defItem.setDefType(this.getSpecDefType());
        }
        CatalogDefOperationType operation = CatalogDefOperationType.CONSIST;
        switch (defItem.getDefType()) {
            case CONSIST: {
                operation = defItem.getTarget() == null && this.spec instanceof XBCBlockSpec ? CatalogDefOperationType.ANY : CatalogDefOperationType.CONSIST;
                break;
            }
            case JOIN: {
                operation = defItem.getTarget() == null && this.spec instanceof XBCBlockSpec ? CatalogDefOperationType.ATTRIBUTE : CatalogDefOperationType.JOIN;
                break;
            }
            case LIST_CONSIST: {
                operation = defItem.getTarget() == null ? CatalogDefOperationType.ANY_LIST : CatalogDefOperationType.CONSIST_LIST;
                break;
            }
            case LIST_JOIN: {
                operation = defItem.getTarget() == null ? CatalogDefOperationType.ATTRIBUTE_LIST : CatalogDefOperationType.JOIN_LIST;
            }
        }
        this.operationComboBox.setSelectedIndex(operation.getRowIndex());
        this.updateSpecDefType();
        this.setTargetRev(defItem.getTarget());
    }

    public XBParamType getSpecDefType() {
        if (this.spec instanceof XBCBlockSpec) {
            switch (this.getOperation()) {
                case CONSIST: {
                    return XBParamType.CONSIST;
                }
                case JOIN: {
                    return XBParamType.JOIN;
                }
                case ANY: {
                    return XBParamType.CONSIST;
                }
                case ATTRIBUTE: {
                    return XBParamType.JOIN;
                }
                case CONSIST_LIST: {
                    return XBParamType.LIST_CONSIST;
                }
                case JOIN_LIST: {
                    return XBParamType.LIST_JOIN;
                }
                case ANY_LIST: {
                    return XBParamType.LIST_CONSIST;
                }
                case ATTRIBUTE_LIST: {
                    return XBParamType.LIST_JOIN;
                }
            }
            return XBParamType.CONSIST;
        }
        if (this.getOperation() == CatalogDefOperationType.CONSIST) {
            return XBParamType.CONSIST;
        }
        return XBParamType.JOIN;
    }

    private void switchSpecDefType(CatalogItemType newType) {
        this.definitionTargetTextField.setText("");
        this.targetType = newType;
        this.targetRev = null;
    }

    private void updateSpecDefType() {
        CatalogDefOperationType operation = this.getOperation();
        if (this.spec instanceof XBCBlockSpec) {
            if (!this.getOperationRequireTarget(operation)) {
                this.switchSpecDefType(CatalogItemType.BLOCK);
            }
        } else if (this.spec instanceof XBCGroupSpec) {
            if (operation == CatalogDefOperationType.CONSIST) {
                this.switchSpecDefType(CatalogItemType.BLOCK);
            } else {
                this.switchSpecDefType(CatalogItemType.GROUP);
            }
        } else if (this.spec instanceof XBCFormatSpec) {
            if (operation == CatalogDefOperationType.CONSIST) {
                this.switchSpecDefType(CatalogItemType.GROUP);
            } else {
                this.switchSpecDefType(CatalogItemType.FORMAT);
            }
        }
        if (this.spec instanceof XBCBlockSpec) {
            this.selectTargetButton.setEnabled(this.getOperationRequireTarget(operation));
        } else {
            this.selectTargetButton.setEnabled(true);
        }
    }

    private void setTargetRev(XBCRev targetRev) {
        this.targetRev = targetRev;
        if (targetRev != null) {
            XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
            String targetCaption = nameService.getItemNamePath((XBCItem)targetRev.getParent());
            targetCaption = targetCaption == null ? "" : targetCaption + " ";
            targetCaption = targetCaption + "(" + Long.toString(targetRev.getParent().getId()) + ")";
            this.definitionTargetTextField.setText(targetCaption);
        } else {
            this.definitionTargetTextField.setText("");
        }
    }

    private CatalogDefOperationType getOperation() {
        return CatalogDefOperationType.valueOf((int)this.operationComboBox.getSelectedIndex());
    }

    private boolean getOperationRequireTarget(CatalogDefOperationType operation) {
        return operation == CatalogDefOperationType.CONSIST || operation == CatalogDefOperationType.JOIN || operation == CatalogDefOperationType.CONSIST_LIST || operation == CatalogDefOperationType.JOIN_LIST;
    }
}

