/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.revision.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.xbup.catalog.item.gui.CatalogItemType;
import org.exbin.framework.xbup.catalog.item.gui.CatalogItemsSearchPanel;
import org.exbin.framework.xbup.catalog.item.revision.gui.CatalogRevsComboBoxModel;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCRev;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.service.XBCRevService;

@ParametersAreNonnullByDefault
public class CatalogSelectRevPanel
extends JPanel {
    private XBApplication application;
    private XBCRevService revService;
    private final CatalogItemsSearchPanel selectSpecPanel;
    private final CatalogRevsComboBoxModel revsModel;
    private boolean selectEnabled;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CatalogSelectRevPanel.class);
    private JPanel revisionSelectionPanel;
    private JComboBox<XBCRev> targetRevisionComboBox;

    public CatalogSelectRevPanel(XBACatalog catalog, CatalogItemType specType) {
        this.revsModel = new CatalogRevsComboBoxModel();
        this.selectSpecPanel = new CatalogItemsSearchPanel();
        this.selectSpecPanel.setCatalog(catalog);
        this.initComponents();
        if (catalog != null) {
            this.revService = (XBCRevService)catalog.getCatalogService(XBCRevService.class);
        }
        this.init();
        this.selectSpecPanel.switchToSpecTypeMode(specType);
    }

    private void init() {
        this.add(this.selectSpecPanel);
        this.selectSpecPanel.setSelectionListener(spec -> {
            boolean bl = this.selectEnabled = spec != null;
            if (spec != null) {
                if (spec instanceof XBCSpec) {
                    this.revsModel.setRevs(this.revService.getRevs((XBCSpec)spec));
                    this.targetRevisionComboBox.setSelectedIndex(this.revsModel.getSize() - 1);
                } else {
                    this.revsModel.getRevs().clear();
                }
            } else {
                this.targetRevisionComboBox.setSelectedIndex(-1);
                this.revsModel.getRevs().clear();
            }
            this.revsModel.fireDataChanged();
        });
        this.targetRevisionComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                DefaultListCellRenderer retValue = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof XBCRev) {
                    retValue.setText("Revision " + ((XBCRev)value).getXBIndex());
                }
                return retValue;
            }
        });
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        this.selectSpecPanel.setApplication(application);
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    private void initComponents() {
        this.revisionSelectionPanel = new JPanel();
        this.targetRevisionComboBox = new JComboBox();
        this.setLayout(new BorderLayout());
        this.targetRevisionComboBox.setModel(this.revsModel);
        GroupLayout revisionSelectionPanelLayout = new GroupLayout(this.revisionSelectionPanel);
        this.revisionSelectionPanel.setLayout(revisionSelectionPanelLayout);
        revisionSelectionPanelLayout.setHorizontalGroup(revisionSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(revisionSelectionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.targetRevisionComboBox, 0, 388, Short.MAX_VALUE).addContainerGap()));
        revisionSelectionPanelLayout.setVerticalGroup(revisionSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, revisionSelectionPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.targetRevisionComboBox, -2, -1, -2).addContainerGap()));
        this.add((Component)this.revisionSelectionPanel, "Last");
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogSelectRevPanel(null, CatalogItemType.NODE));
    }

    public boolean isSelectEnabled() {
        return this.selectEnabled;
    }

    public XBCItem getSpec() {
        return this.selectSpecPanel.getItem();
    }

    public void setSpec(XBCItem spec) {
        this.selectSpecPanel.setItem(spec);
    }

    public XBCRev getTarget() {
        return (XBCRev)this.targetRevisionComboBox.getSelectedItem();
    }

    public void setTarget(XBCRev rev) {
        XBCSpec specification;
        if (rev != null) {
            specification = rev.getParent();
            this.revsModel.setRevs(this.revService.getRevs(specification));
            this.targetRevisionComboBox.setSelectedIndex((int)rev.getXBIndex());
        } else {
            specification = null;
        }
        this.setSpec((XBCItem)specification);
    }
}

