/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.plugin.ation;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;
import org.exbin.framework.xbup.catalog.item.plugin.gui.CatalogEditNodePluginPanel;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBENode;
import org.exbin.xbup.catalog.entity.XBEXFile;
import org.exbin.xbup.catalog.entity.XBEXPlugUi;
import org.exbin.xbup.catalog.entity.XBEXPlugUiType;
import org.exbin.xbup.catalog.entity.XBEXPlugin;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBPlugUiType;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCXFile;
import org.exbin.xbup.core.catalog.base.XBCXPlugUiType;
import org.exbin.xbup.core.catalog.base.XBCXPlugin;
import org.exbin.xbup.core.catalog.base.service.XBCXUiService;

@ParametersAreNonnullByDefault
public class AddItemPluginAction
extends AbstractAction {
    public static final String ACTION_ID = "addCatalogItemPluginAction";
    private XBApplication application;
    private XBACatalog catalog;
    private Component parentComponent;
    private XBCNode currentNode;
    private int currentCount;
    private ResultData resultData;

    public void setup(XBApplication application) {
        this.application = application;
    }

    @Nullable
    public XBCNode getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(XBCNode currentNode) {
        this.currentNode = currentNode;
    }

    public void setCurrentCount(int currentCount) {
        this.currentCount = currentCount;
    }

    @Nullable
    public ResultData getResultData() {
        return this.resultData;
    }

    public void setParentComponent(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    @Override
    public void actionPerformed(@Nullable ActionEvent event) {
        this.resultData = null;
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        CatalogEditNodePluginPanel editPanel = new CatalogEditNodePluginPanel();
        editPanel.setApplication(this.application);
        editPanel.setCatalog(this.catalog);
        editPanel.setNode(this.currentNode);
        DefaultControlPanel controlPanel = new DefaultControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)editPanel, (JPanel)controlPanel);
        frameModule.setDialogTitle(dialog, editPanel.getResourceBundle());
        controlPanel.setHandler(actionType -> {
            if (actionType == DefaultControlHandler.ControlActionType.OK) {
                XBCXUiService uiService = (XBCXUiService)this.catalog.getCatalogService(XBCXUiService.class);
                XBCXFile file = editPanel.getFile();
                long rowEditorsCount = editPanel.getRowEditorsCount();
                long panelViewersCount = editPanel.getPanelViewersCount();
                long panelEditorsCount = editPanel.getPanelEditorsCount();
                XBEXPlugin plugin = new XBEXPlugin();
                plugin.setOwner((XBCNode)((XBENode)this.currentNode));
                plugin.setPluginFile((XBCXFile)((XBEXFile)file));
                plugin.setPluginIndex(Long.valueOf(this.currentCount).longValue());
                EntityManager em = ((XBECatalog)this.catalog).getEntityManager();
                EntityTransaction transaction = em.getTransaction();
                transaction.begin();
                em.persist((Object)plugin);
                XBEXPlugUiType rowEditorType = (XBEXPlugUiType)uiService.findTypeById(XBPlugUiType.ROW_EDITOR.getDbIndex());
                for (long i = 0L; i < rowEditorsCount; ++i) {
                    XBEXPlugUi plugUi = new XBEXPlugUi();
                    plugUi.setPlugin((XBCXPlugin)plugin);
                    plugUi.setUiType((XBCXPlugUiType)rowEditorType);
                    plugUi.setMethodIndex(i);
                    em.persist((Object)plugUi);
                }
                XBEXPlugUiType panelViewerType = (XBEXPlugUiType)uiService.findTypeById(XBPlugUiType.PANEL_VIEWER.getDbIndex());
                for (long i = 0L; i < panelViewersCount; ++i) {
                    XBEXPlugUi plugUi = new XBEXPlugUi();
                    plugUi.setPlugin((XBCXPlugin)plugin);
                    plugUi.setUiType((XBCXPlugUiType)panelViewerType);
                    plugUi.setMethodIndex(i);
                    em.persist((Object)plugUi);
                }
                XBEXPlugUiType panelEditorType = (XBEXPlugUiType)uiService.findTypeById(XBPlugUiType.PANEL_EDITOR.getDbIndex());
                for (long i = 0L; i < panelEditorsCount; ++i) {
                    XBEXPlugUi plugUi = new XBEXPlugUi();
                    plugUi.setPlugin((XBCXPlugin)plugin);
                    plugUi.setUiType((XBCXPlugUiType)panelEditorType);
                    plugUi.setMethodIndex(i);
                    em.persist((Object)plugUi);
                }
                em.flush();
                transaction.commit();
                this.resultData = new ResultData();
                this.resultData.plugin = plugin;
                this.resultData.file = file;
                this.resultData.rowEditorsCount = rowEditorsCount;
                this.resultData.panelViewersCount = panelViewersCount;
                this.resultData.panelEditorsCount = panelEditorsCount;
            }
            dialog.close();
        });
        dialog.showCentered(this.parentComponent);
        dialog.dispose();
    }

    public void setCatalog(@Nullable XBACatalog catalog) {
        this.catalog = catalog;
    }

    public static final class ResultData {
        public XBEXPlugin plugin;
        public XBCXFile file;
        public long rowEditorsCount;
        public long panelViewersCount;
        public long panelEditorsCount;
    }
}

