/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.gui;

import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.xbup.catalog.item.gui.CatalogItemType;

@ParametersAreNonnullByDefault
public class CatalogAddItemPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CatalogAddItemPanel.class);
    private JLabel itemNameLabel;
    private JTextField itemNameTextField;
    private JComboBox itemTypeComboBox;
    private JLabel itemTypeLabel;

    public CatalogAddItemPanel() {
        this.initComponents();
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    private void initComponents() {
        this.itemTypeLabel = new JLabel();
        this.itemTypeComboBox = new JComboBox();
        this.itemNameLabel = new JLabel();
        this.itemNameTextField = new JTextField();
        this.itemTypeLabel.setText(this.resourceBundle.getString("itemTypeLabel.text"));
        this.itemTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Node", "Block Specification", "Group Specification", "Format Specification"}));
        this.itemNameLabel.setText(this.resourceBundle.getString("itemNameLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.itemTypeComboBox, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.itemTypeLabel).addComponent(this.itemNameLabel)).addGap(0, 236, Short.MAX_VALUE)).addComponent(this.itemNameTextField)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.itemTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.itemTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.itemNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.itemNameTextField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogAddItemPanel());
    }

    @Nullable
    public CatalogItemType getItemType() {
        switch (this.itemTypeComboBox.getSelectedIndex()) {
            case 0: {
                return CatalogItemType.NODE;
            }
            case 1: {
                return CatalogItemType.BLOCK;
            }
            case 2: {
                return CatalogItemType.GROUP;
            }
            case 3: {
                return CatalogItemType.FORMAT;
            }
        }
        return null;
    }

    @Nullable
    public String getItemName() {
        return this.itemNameTextField.getText();
    }
}

