/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.component.api.ActionsProvider;
import org.exbin.framework.component.api.toolbar.EditItemActionsUpdateListener;
import org.exbin.framework.component.gui.ToolBarSidePanel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.xbup.catalog.item.gui.CatalogItemPanel;
import org.exbin.framework.xbup.catalog.item.gui.CatalogNodesTreeModel;
import org.exbin.framework.xbup.catalog.item.spec.gui.CatalogSpecsTableModel;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCRoot;
import org.exbin.xbup.core.catalog.base.XBCSpec;

@ParametersAreNonnullByDefault
public class CatalogEditorPanel
extends JPanel {
    private XBApplication application;
    private XBCItem currentItem;
    private final ToolBarSidePanel catalogTreePanel = new ToolBarSidePanel();
    private final ToolBarSidePanel catalogItemPanel = new ToolBarSidePanel();
    private XBACatalog catalog;
    private CatalogNodesTreeModel nodesModel;
    private CatalogSpecsTableModel specsModel;
    private final CatalogItemPanel itemPanel;
    private EditItemActionsUpdateListener itemSelectionListener;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CatalogEditorPanel.class);
    private XBCRoot catalogRoot;
    private JScrollPane catalogItemListScrollPane;
    private JSplitPane catalogItemSplitPane;
    private JTable catalogSpecListTable;
    private JTree catalogTree;
    private JScrollPane catalogTreeScrollPane;
    private JSplitPane panelSplitPane;

    public CatalogEditorPanel() {
        this.nodesModel = new CatalogNodesTreeModel();
        this.specsModel = new CatalogSpecsTableModel();
        this.itemPanel = new CatalogItemPanel();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.catalogTree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultTreeCellRenderer retValue = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof CatalogNodesTreeModel.CatalogNodesTreeItem) {
                    XBCNode node = ((CatalogNodesTreeModel.CatalogNodesTreeItem)value).getNode();
                    String nodeName = ((CatalogNodesTreeModel.CatalogNodesTreeItem)value).getName();
                    if (nodeName == null) {
                        retValue.setText("node [" + String.valueOf(node.getId()) + "]");
                    } else {
                        retValue.setText(nodeName);
                    }
                }
                return retValue;
            }
        });
        this.catalogTree.getSelectionModel().setSelectionMode(1);
        this.catalogSpecListTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                if (this.catalogSpecListTable.getSelectedRow() >= 0) {
                    this.setItem(this.specsModel.getItem(this.catalogSpecListTable.getSelectedRow()));
                } else {
                    this.setItem(null);
                }
            }
        });
        this.catalogItemSplitPane.setRightComponent(this.itemPanel);
        this.itemPanel.setJumpActionListener(rev -> {
            XBCSpec spec = rev.getParent();
            TreePath nodePath = this.nodesModel.findPathForSpec(spec);
            if (nodePath != null) {
                this.catalogTree.scrollPathToVisible(nodePath);
                this.catalogTree.setSelectionPath(nodePath);
                this.selectSpecTableRow((XBCItem)spec);
            }
        });
        this.catalogItemPanel.setToolBarPosition(ToolBarSidePanel.ToolBarPosition.RIGHT);
        this.catalogTreePanel.add((Component)this.catalogTreeScrollPane, (Object)"Center");
        this.catalogItemPanel.add((Component)this.catalogItemSplitPane, (Object)"Center");
        this.panelSplitPane.setLeftComponent((Component)this.catalogTreePanel);
        this.panelSplitPane.setRightComponent((Component)this.catalogItemPanel);
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void addTreeActions(ActionsProvider actionsProvider) {
        this.catalogTreePanel.addActions(actionsProvider);
    }

    public void addItemActions(ActionsProvider actionsProvider) {
        this.catalogItemPanel.addActions(actionsProvider);
    }

    public void addTreeSelectionListener(EditItemActionsUpdateListener updateListener) {
        this.catalogTree.getSelectionModel().addTreeSelectionListener((TreeSelectionEvent e) -> updateListener.stateChanged());
    }

    public void addItemSelectionListener(EditItemActionsUpdateListener updateListener) {
        this.itemSelectionListener = updateListener;
        this.catalogSpecListTable.getSelectionModel().addListSelectionListener(e -> updateListener.stateChanged());
    }

    public void setTreePanelPopup(JPopupMenu popupMenu) {
        this.catalogTree.setComponentPopupMenu(popupMenu);
    }

    public void setItemPanelPopup(JPopupMenu popupMenu) {
        this.catalogSpecListTable.setComponentPopupMenu(popupMenu);
    }

    private void initComponents() {
        this.catalogTreeScrollPane = new JScrollPane();
        this.catalogTree = new JTree();
        this.catalogItemSplitPane = new JSplitPane();
        this.catalogItemListScrollPane = new JScrollPane();
        this.catalogSpecListTable = new JTable();
        this.panelSplitPane = new JSplitPane();
        this.catalogTreeScrollPane.setName("catalogTreeScrollPane");
        this.catalogTree.setModel(this.nodesModel);
        this.catalogTree.setName("catalogTree");
        this.catalogTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                CatalogEditorPanel.this.catalogTreeValueChanged(evt);
            }
        });
        this.catalogTreeScrollPane.setViewportView(this.catalogTree);
        this.catalogItemSplitPane.setDividerLocation(180);
        this.catalogItemSplitPane.setOrientation(0);
        this.catalogItemSplitPane.setName("catalogItemSplitPane");
        this.catalogItemListScrollPane.setName("catalogItemListScrollPane");
        this.catalogSpecListTable.setModel(this.specsModel);
        this.catalogSpecListTable.setName("catalogSpecListTable");
        this.catalogSpecListTable.setSelectionMode(0);
        this.catalogItemListScrollPane.setViewportView(this.catalogSpecListTable);
        this.catalogItemSplitPane.setLeftComponent(this.catalogItemListScrollPane);
        this.setName("Form");
        this.setLayout(new BorderLayout());
        this.panelSplitPane.setDividerLocation(100);
        this.panelSplitPane.setName("panelSplitPane");
        this.add((Component)this.panelSplitPane, "Center");
    }

    private void catalogTreeValueChanged(TreeSelectionEvent evt) {
        if (this.catalogTree.getLastSelectedPathComponent() != null) {
            if (this.nodesModel.isLeaf(this.catalogTree.getLastSelectedPathComponent())) {
                this.setNode(((CatalogNodesTreeModel.CatalogNodesTreeItem)this.catalogTree.getLastSelectedPathComponent()).getNode());
            } else {
                this.setNode(((CatalogNodesTreeModel.CatalogNodesTreeItem)this.catalogTree.getLastSelectedPathComponent()).getNode());
            }
        } else {
            this.setNode(null);
        }
    }

    @Nullable
    public XBCNode getSelectedTreeItem() {
        TreePath selectionPath = this.catalogTree.getSelectionPath();
        return selectionPath == null ? null : ((CatalogNodesTreeModel.CatalogNodesTreeItem)selectionPath.getLastPathComponent()).getNode();
    }

    @Nullable
    public XBCItem getCurrentItem() {
        return this.currentItem;
    }

    public void setNode(@Nullable XBCNode node) {
        this.setItem((XBCItem)node);
        this.specsModel.setNode(node);
        if (node != null) {
            this.catalogSpecListTable.setRowSelectionInterval(0, 0);
        }
        this.catalogSpecListTable.revalidate();
    }

    public void setItem(@Nullable XBCItem item) {
        this.currentItem = item;
        this.itemPanel.setItem(item);
        if (this.itemSelectionListener != null) {
            this.itemSelectionListener.stateChanged();
        }
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogEditorPanel());
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.specsModel.setCatalog(catalog);
        this.itemPanel.setCatalog(catalog);
    }

    public void setCatalogRoot(XBCRoot catalogRoot) {
        this.catalogRoot = catalogRoot;
        this.reloadNodesTree();
    }

    public void selectSpecTableRow(XBCItem item) {
        CatalogSpecsTableModel catalogSpecsTableModel = this.specsModel;
        catalogSpecsTableModel.getClass();
        int specRow = this.specsModel.getIndexOfItem(catalogSpecsTableModel.new CatalogSpecsTableModel.CatalogSpecTableItem(item));
        if (specRow >= 0) {
            this.catalogSpecListTable.setRowSelectionInterval(specRow, specRow);
            this.catalogSpecListTable.scrollRectToVisible(new Rectangle(this.catalogSpecListTable.getCellRect(specRow, 0, true)));
        }
    }

    @Nullable
    public XBCNode getSpecsNode() {
        return this.specsModel.getNode();
    }

    public void setSpecsNode(@Nullable XBCNode node) {
        this.specsModel.setNode(node);
    }

    public void reloadNodesTree() {
        this.nodesModel = new CatalogNodesTreeModel(this.catalogRoot.getNode());
        this.nodesModel.setCatalog((XBCatalog)this.catalog);
        this.catalogTree.setModel(this.nodesModel);
    }
}

