/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.exbin.framework.action.api.MenuManagement;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.component.action.DefaultEditItemActions;
import org.exbin.framework.component.api.ActionsProvider;
import org.exbin.framework.component.api.toolbar.EditItemActionsHandler;
import org.exbin.framework.component.api.toolbar.EditItemActionsUpdateListener;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.xbup.catalog.XbupCatalogModule;
import org.exbin.framework.xbup.catalog.gui.CatalogEditorPanel;
import org.exbin.framework.xbup.catalog.item.action.AddCatalogItemAction;
import org.exbin.framework.xbup.catalog.item.action.DeleteCatalogItemAction;
import org.exbin.framework.xbup.catalog.item.action.EditCatalogItemAction;
import org.exbin.framework.xbup.catalog.item.action.ExportItemAction;
import org.exbin.framework.xbup.catalog.item.action.ImportItemAction;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCRoot;

@ParametersAreNonnullByDefault
public class CatalogEditor {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CatalogEditor.class);
    private final CatalogEditorPanel catalogEditorPanel;
    private final DefaultEditItemActions treeActions;
    private final DefaultEditItemActions itemActions;
    private XBApplication application;
    private XBACatalog catalog;
    private JPopupMenu catalogTreePopupMenu;
    private JPopupMenu catalogItemPopupMenu;
    private AddCatalogItemAction addCatalogItemAction = new AddCatalogItemAction();
    private EditCatalogItemAction editCatalogItemAction = new EditCatalogItemAction();
    private DeleteCatalogItemAction deleteCatalogItemAction = new DeleteCatalogItemAction();
    private ExportItemAction exportItemAction;
    private ImportItemAction importItemAction;
    private ExportItemAction exportTreeItemAction;
    private ImportItemAction importTreeItemAction;
    private XBCRoot catalogRoot;

    public CatalogEditor() {
        this.catalogEditorPanel = new CatalogEditorPanel();
        this.addCatalogItemAction.setParentComponent(this.catalogEditorPanel);
        this.editCatalogItemAction.setParentComponent(this.catalogEditorPanel);
        this.deleteCatalogItemAction.setParentComponent(this.catalogEditorPanel);
        this.exportItemAction = new ExportItemAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                this.setCurrentItem(CatalogEditor.this.catalogEditorPanel.getCurrentItem());
                super.actionPerformed(event);
            }
        };
        this.exportItemAction.setParentComponent(this.catalogEditorPanel);
        this.importItemAction = new ImportItemAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                this.setCurrentItem(CatalogEditor.this.catalogEditorPanel.getCurrentItem());
                super.actionPerformed(event);
            }
        };
        this.importItemAction.setParentComponent(this.catalogEditorPanel);
        this.exportTreeItemAction = new ExportItemAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                this.setCurrentItem((XBCItem)CatalogEditor.this.catalogEditorPanel.getSelectedTreeItem());
                super.actionPerformed(event);
            }
        };
        this.exportTreeItemAction.setParentComponent(this.catalogEditorPanel);
        this.importTreeItemAction = new ImportItemAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                this.setCurrentItem((XBCItem)CatalogEditor.this.catalogEditorPanel.getSelectedTreeItem());
                super.actionPerformed(event);
            }
        };
        this.importTreeItemAction.setParentComponent(this.catalogEditorPanel);
        this.treeActions = new DefaultEditItemActions(DefaultEditItemActions.Mode.DIALOG);
        this.treeActions.setEditItemActionsHandler(new EditItemActionsHandler(){

            public void performAddItem() {
                CatalogEditor.this.addCatalogItemAction.setCurrentItem((XBCItem)CatalogEditor.this.catalogEditorPanel.getSelectedTreeItem());
                CatalogEditor.this.addCatalogItemAction.actionPerformed(null);
                XBCItem resultItem = CatalogEditor.this.addCatalogItemAction.getResultItem();
                if (resultItem != null) {
                    CatalogEditor.this.catalogEditorPanel.reloadNodesTree();
                    CatalogEditor.this.catalogEditorPanel.setNode(resultItem instanceof XBCNode ? (XBCNode)resultItem : CatalogEditor.this.catalogEditorPanel.getSpecsNode());
                    CatalogEditor.this.catalogEditorPanel.selectSpecTableRow(resultItem);
                }
            }

            public void performEditItem() {
                CatalogEditor.this.editCatalogItemAction.setCurrentItem((XBCItem)CatalogEditor.this.catalogEditorPanel.getSelectedTreeItem());
                CatalogEditor.this.editCatalogItemAction.actionPerformed(null);
                CatalogEditor.this.catalogEditorPanel.reloadNodesTree();
            }

            public void performDeleteItem() {
                CatalogEditor.this.deleteCatalogItemAction.setCurrentItem((XBCItem)CatalogEditor.this.catalogEditorPanel.getSelectedTreeItem());
                CatalogEditor.this.deleteCatalogItemAction.actionPerformed(null);
                CatalogEditor.this.catalogEditorPanel.reloadNodesTree();
            }

            public boolean canAddItem() {
                return true;
            }

            public boolean canEditItem() {
                XBCNode item = CatalogEditor.this.catalogEditorPanel.getSelectedTreeItem();
                return item != null;
            }

            public boolean canDeleteItem() {
                XBCNode node = CatalogEditor.this.catalogEditorPanel.getSelectedTreeItem();
                return node != null && node.getParent().isPresent();
            }

            public void setUpdateListener(@Nonnull EditItemActionsUpdateListener updateListener) {
                CatalogEditor.this.catalogEditorPanel.addTreeSelectionListener(updateListener);
            }
        });
        this.itemActions = new DefaultEditItemActions(DefaultEditItemActions.Mode.DIALOG);
        this.itemActions.setEditItemActionsHandler(new EditItemActionsHandler(){

            public void performAddItem() {
                CatalogEditor.this.addCatalogItemAction.setCurrentItem(CatalogEditor.this.catalogEditorPanel.getCurrentItem());
                CatalogEditor.this.addCatalogItemAction.actionPerformed(null);
                XBCItem resultItem = CatalogEditor.this.addCatalogItemAction.getResultItem();
                if (resultItem != null) {
                    CatalogEditor.this.catalogEditorPanel.setItem(resultItem);
                    CatalogEditor.this.catalogEditorPanel.setSpecsNode(CatalogEditor.this.catalogEditorPanel.getSpecsNode());
                    CatalogEditor.this.catalogEditorPanel.selectSpecTableRow(resultItem);
                }
            }

            public void performEditItem() {
                CatalogEditor.this.editCatalogItemAction.setCurrentItem(CatalogEditor.this.catalogEditorPanel.getCurrentItem());
                CatalogEditor.this.editCatalogItemAction.actionPerformed(null);
                XBCItem resultItem = CatalogEditor.this.editCatalogItemAction.getResultItem();
                if (resultItem != null) {
                    CatalogEditor.this.catalogEditorPanel.setItem(resultItem);
                    CatalogEditor.this.catalogEditorPanel.setSpecsNode(CatalogEditor.this.catalogEditorPanel.getSpecsNode());
                    CatalogEditor.this.catalogEditorPanel.selectSpecTableRow(resultItem);
                }
            }

            public void performDeleteItem() {
                CatalogEditor.this.deleteCatalogItemAction.setCurrentItem(CatalogEditor.this.catalogEditorPanel.getCurrentItem());
                CatalogEditor.this.deleteCatalogItemAction.actionPerformed(null);
            }

            public boolean canAddItem() {
                return CatalogEditor.this.catalogEditorPanel.getSelectedTreeItem() != null;
            }

            public boolean canEditItem() {
                return CatalogEditor.this.catalogEditorPanel.getCurrentItem() != null;
            }

            public boolean canDeleteItem() {
                XBCItem currentItem = CatalogEditor.this.catalogEditorPanel.getCurrentItem();
                return currentItem != null && currentItem != CatalogEditor.this.catalogEditorPanel.getSelectedTreeItem();
            }

            public void setUpdateListener(@Nonnull EditItemActionsUpdateListener updateListener) {
                CatalogEditor.this.catalogEditorPanel.addItemSelectionListener(updateListener);
            }
        });
        this.catalogTreePopupMenu = new JPopupMenu();
        this.catalogEditorPanel.setTreePanelPopup(this.catalogTreePopupMenu);
        this.catalogItemPopupMenu = new JPopupMenu();
        this.catalogEditorPanel.setItemPanelPopup(this.catalogItemPopupMenu);
        this.catalogEditorPanel.addTreeActions((ActionsProvider)this.treeActions);
        this.catalogEditorPanel.addItemActions((ActionsProvider)this.itemActions);
    }

    @Nonnull
    public CatalogEditorPanel getCatalogEditorPanel() {
        return this.catalogEditorPanel;
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        this.catalogEditorPanel.setApplication(application);
        this.addCatalogItemAction.setup(application);
        this.editCatalogItemAction.setup(application);
        this.deleteCatalogItemAction.setup(application);
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.catalogEditorPanel.setCatalog(catalog);
        this.addCatalogItemAction.setCatalog(catalog);
        this.editCatalogItemAction.setCatalog(catalog);
        this.deleteCatalogItemAction.setCatalog(catalog);
        this.exportItemAction.setup(this.application, catalog);
        this.importItemAction.setup(this.application, catalog);
        this.exportTreeItemAction.setup(this.application, catalog);
        this.importTreeItemAction.setup(this.application, catalog);
        XbupCatalogModule managerModule = (XbupCatalogModule)this.application.getModuleRepository().getModuleByInterface(XbupCatalogModule.class);
        MenuManagement menuManagement = managerModule.getDefaultMenuManagement();
        if (this.catalogTreePopupMenu.getComponentCount() == 0) {
            JMenuItem addTreeItem = ActionUtils.actionToMenuItem((Action)this.treeActions.getAddItemAction());
            addTreeItem.setText(this.resourceBundle.getString("addTreeItem.text") + "...");
            this.catalogTreePopupMenu.add(addTreeItem);
            JMenuItem editTreeItem = ActionUtils.actionToMenuItem((Action)this.treeActions.getEditItemAction());
            editTreeItem.setText(this.resourceBundle.getString("editTreeItem.text") + "...");
            this.catalogTreePopupMenu.add(editTreeItem);
            this.catalogTreePopupMenu.addSeparator();
            this.catalogTreePopupMenu.addSeparator();
            this.catalogTreePopupMenu.add(ActionUtils.actionToMenuItem((Action)this.exportTreeItemAction));
            this.catalogTreePopupMenu.add(ActionUtils.actionToMenuItem((Action)this.importTreeItemAction));
            menuManagement.insertMainPopupMenu(this.catalogTreePopupMenu, 3);
        }
        if (this.catalogItemPopupMenu.getComponentCount() == 0) {
            JMenuItem addCatalogItem = ActionUtils.actionToMenuItem((Action)this.itemActions.getAddItemAction());
            addCatalogItem.setText(this.resourceBundle.getString("addCatalogItem.text") + "...");
            this.catalogItemPopupMenu.add(addCatalogItem);
            JMenuItem editCatalogItem = ActionUtils.actionToMenuItem((Action)this.itemActions.getEditItemAction());
            editCatalogItem.setText(this.resourceBundle.getString("editCatalogItem.text") + "...");
            this.catalogItemPopupMenu.add(editCatalogItem);
            this.catalogItemPopupMenu.addSeparator();
            this.catalogItemPopupMenu.addSeparator();
            this.catalogItemPopupMenu.add(ActionUtils.actionToMenuItem((Action)this.exportItemAction));
            this.catalogItemPopupMenu.add(ActionUtils.actionToMenuItem((Action)this.importItemAction));
            menuManagement.insertMainPopupMenu(this.catalogItemPopupMenu, 3);
        }
    }

    public void setCatalogRoot(XBCRoot catalogRoot) {
        this.catalogRoot = catalogRoot;
        this.catalogEditorPanel.setCatalogRoot(catalogRoot);
    }
}

