/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.file;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import javax.swing.JMenu;
import org.exbin.framework.action.api.ActionModuleApi;
import org.exbin.framework.action.api.MenuGroup;
import org.exbin.framework.action.api.MenuPosition;
import org.exbin.framework.action.api.NextToMode;
import org.exbin.framework.action.api.PositionMode;
import org.exbin.framework.action.api.ToolBarGroup;
import org.exbin.framework.action.api.ToolBarPosition;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.file.action.FileActions;
import org.exbin.framework.file.action.NewFileAction;
import org.exbin.framework.file.action.OpenFileAction;
import org.exbin.framework.file.action.RecentFilesActions;
import org.exbin.framework.file.action.SaveAsFileAction;
import org.exbin.framework.file.action.SaveFileAction;
import org.exbin.framework.file.api.FileModuleApi;
import org.exbin.framework.file.api.FileOperations;
import org.exbin.framework.file.api.FileOperationsProvider;
import org.exbin.framework.file.api.FileType;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.plugin.XBModuleHandler;

@ParametersAreNonnullByDefault
public class FileModule
implements FileModuleApi,
FileOperationsProvider {
    private ResourceBundle resourceBundle = null;
    private XBApplication application;
    private FileOperations fileOperations;
    private NewFileAction newFileAction;
    private OpenFileAction openFileAction;
    private SaveFileAction saveFileAction;
    private SaveAsFileAction saveAsFileAction;
    private RecentFilesActions recentFilesActions;
    private FileActions fileActions;
    private final List<FileType> registeredFileTypes = new ArrayList<FileType>();

    public void init(XBModuleHandler moduleHandler) {
        this.application = (XBApplication)moduleHandler;
    }

    public void unregisterModule(String moduleId) {
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = LanguageUtils.getResourceBundleByClass(FileModule.class);
        }
        return this.resourceBundle;
    }

    private void ensureSetup() {
        if (this.resourceBundle == null) {
            this.getResourceBundle();
        }
    }

    @Nullable
    public FileOperations getFileOperations() {
        return this.fileOperations;
    }

    public void setFileOperations(@Nullable FileOperations fileOperations) {
        this.fileOperations = fileOperations;
    }

    public void addFileType(FileType fileType) {
        this.registeredFileTypes.add(fileType);
    }

    @Nonnull
    public Collection<FileType> getFileTypes() {
        return Collections.unmodifiableCollection(this.registeredFileTypes);
    }

    public void registerMenuFileHandlingActions() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuGroup(FrameModuleApi.FILE_MENU_ID, new MenuGroup(FILE_MENU_GROUP_ID, new MenuPosition(PositionMode.TOP)));
        actionModule.registerMenuItem(FrameModuleApi.FILE_MENU_ID, MODULE_ID, (Action)this.getNewFileAction(), new MenuPosition(FILE_MENU_GROUP_ID));
        actionModule.registerMenuItem(FrameModuleApi.FILE_MENU_ID, MODULE_ID, (Action)this.getOpenFileAction(), new MenuPosition(FILE_MENU_GROUP_ID));
        actionModule.registerMenuItem(FrameModuleApi.FILE_MENU_ID, MODULE_ID, (Action)this.getSaveFileAction(), new MenuPosition(FILE_MENU_GROUP_ID));
        actionModule.registerMenuItem(FrameModuleApi.FILE_MENU_ID, MODULE_ID, (Action)this.getSaveAsFileAction(), new MenuPosition(FILE_MENU_GROUP_ID));
    }

    public void registerToolBarFileHandlingActions() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerToolBarGroup(FrameModuleApi.MAIN_TOOL_BAR_ID, new ToolBarGroup(FILE_TOOL_BAR_GROUP_ID, new ToolBarPosition(PositionMode.TOP)));
        actionModule.registerToolBarItem(FrameModuleApi.MAIN_TOOL_BAR_ID, MODULE_ID, (Action)this.getNewFileAction(), new ToolBarPosition(FILE_TOOL_BAR_GROUP_ID));
        actionModule.registerToolBarItem(FrameModuleApi.MAIN_TOOL_BAR_ID, MODULE_ID, (Action)this.getOpenFileAction(), new ToolBarPosition(FILE_TOOL_BAR_GROUP_ID));
        actionModule.registerToolBarItem(FrameModuleApi.MAIN_TOOL_BAR_ID, MODULE_ID, (Action)this.getSaveFileAction(), new ToolBarPosition(FILE_TOOL_BAR_GROUP_ID));
    }

    public void registerCloseListener() {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        frameModule.addExitListener(frameHandler -> {
            if (this.fileOperations != null) {
                return this.fileOperations.releaseAllFiles();
            }
            return true;
        });
    }

    public void registerRecenFilesMenuActions() {
        this.getRecentFilesActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        JMenu recentFileMenu = this.recentFilesActions.getOpenRecentMenu();
        actionModule.registerMenuItem(FrameModuleApi.FILE_MENU_ID, MODULE_ID, recentFileMenu, new MenuPosition(NextToMode.AFTER, (String)this.getOpenFileAction().getValue("Name") + "..."));
    }

    @Nonnull
    public NewFileAction getNewFileAction() {
        if (this.newFileAction == null) {
            this.ensureSetup();
            this.newFileAction = new NewFileAction();
            this.newFileAction.setup(this.application, this.resourceBundle, this);
        }
        return this.newFileAction;
    }

    @Nonnull
    public OpenFileAction getOpenFileAction() {
        if (this.openFileAction == null) {
            this.ensureSetup();
            this.openFileAction = new OpenFileAction();
            this.openFileAction.setup(this.application, this.resourceBundle, this);
        }
        return this.openFileAction;
    }

    @Nonnull
    public SaveFileAction getSaveFileAction() {
        if (this.saveFileAction == null) {
            this.ensureSetup();
            this.saveFileAction = new SaveFileAction();
            this.saveFileAction.setup(this.application, this.resourceBundle, this);
        }
        return this.saveFileAction;
    }

    @Nonnull
    public SaveAsFileAction getSaveAsFileAction() {
        if (this.saveAsFileAction == null) {
            this.ensureSetup();
            this.saveAsFileAction = new SaveAsFileAction();
            this.saveAsFileAction.setup(this.application, this.resourceBundle, this);
        }
        return this.saveAsFileAction;
    }

    @Nonnull
    public RecentFilesActions getRecentFilesActions() {
        if (this.recentFilesActions == null) {
            this.recentFilesActions = new RecentFilesActions();
            this.recentFilesActions.setup(this.application, this.resourceBundle, new RecentFilesActions.FilesControl(){

                @Override
                public void loadFromFile(URI fileUri, @Nullable FileType fileType) {
                    FileModule.this.fileOperations.loadFromFile(fileUri, fileType);
                }

                @Override
                @Nonnull
                public List<FileType> getRegisteredFileTypes() {
                    return FileModule.this.registeredFileTypes;
                }
            });
            this.recentFilesActions.setPreferences(this.application.getAppPreferences());
        }
        return this.recentFilesActions;
    }

    public void updateRecentFilesList(URI fileUri, FileType fileType) {
        if (this.recentFilesActions != null) {
            this.recentFilesActions.updateRecentFilesList(fileUri, fileType);
        }
    }

    @Nonnull
    public FileActions getFileActions() {
        if (this.fileActions == null) {
            this.ensureSetup();
            this.fileActions = new FileActions();
            this.fileActions.setup(this.application, this.resourceBundle);
        }
        return this.fileActions;
    }

    public void loadFromFile(String filename) {
        if (this.fileOperations == null) {
            return;
        }
        try {
            this.fileOperations.loadFromFile(filename);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(FileModule.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void loadFromFile(URI fileUri) {
        if (this.fileOperations == null) {
            return;
        }
        this.fileOperations.loadFromFile(fileUri, null);
    }

    public void updateForFileOperations() {
        if (this.saveFileAction != null) {
            this.saveFileAction.updateForFileOperations();
        }
        if (this.saveAsFileAction != null) {
            this.saveAsFileAction.updateForFileOperations();
        }
    }
}

