/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.utils;

import java.awt.Desktop;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

@ParametersAreNonnullByDefault
public class DesktopUtils {
    private static final String ERROR_MESSAGE = "Error attempting to launch web browser";

    private DesktopUtils() {
    }

    public static void openOsURL(String url) {
        DesktopOs basicOs = DesktopUtils.detectBasicOs();
        try {
            switch (basicOs) {
                case MAC_OS: {
                    Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                    Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                    openURL.invoke(null, url);
                    break;
                }
                case WINDOWS: {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                    break;
                }
                default: {
                    String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                    String browser = null;
                    for (int count = 0; count < browsers.length && browser == null; ++count) {
                        if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                        browser = browsers[count];
                    }
                    if (browser == null) {
                        throw new Exception("Could not find web browser");
                    }
                    Runtime.getRuntime().exec(new String[]{browser, url});
                    break;
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error attempting to launch web browser:\n" + e.getLocalizedMessage());
        }
    }

    public static void openDesktopURL(String url) {
        SwingUtilities.invokeLater(() -> {
            Desktop desktop;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                try {
                    URI uri = new URI(url);
                    desktop.browse(uri);
                    return;
                }
                catch (IOException | URISyntaxException ex) {
                    Logger.getLogger(DesktopUtils.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            DesktopUtils.openOsURL(url);
        });
    }

    public static void openDesktopURL(URI uri) {
        SwingUtilities.invokeLater(() -> {
            Desktop desktop;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                try {
                    desktop.browse(uri);
                    return;
                }
                catch (IOException ex) {
                    Logger.getLogger(DesktopUtils.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            DesktopUtils.openOsURL(uri.toString());
        });
    }

    public static void openDesktopURL(URL url) {
        SwingUtilities.invokeLater(() -> {
            Desktop desktop;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                try {
                    URI uri = url.toURI();
                    desktop.browse(uri);
                    return;
                }
                catch (IOException | URISyntaxException ex) {
                    Logger.getLogger(DesktopUtils.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            DesktopUtils.openOsURL(url.toString());
        });
    }

    @Nonnull
    public static DesktopOs detectBasicOs() {
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().startsWith("mac os")) {
            return DesktopOs.MAC_OS;
        }
        if (osName.toLowerCase().startsWith("windows")) {
            return DesktopOs.WINDOWS;
        }
        return DesktopOs.OTHER;
    }

    public static enum DesktopOs {
        MAC_OS,
        WINDOWS,
        OTHER;

    }
}

