/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.plugin;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DynamicClassLoader
extends URLClassLoader {
    public DynamicClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public DynamicClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    void add(URL url) {
        this.addURL(url);
    }

    @Nullable
    public static DynamicClassLoader findAncestor(@Nonnull ClassLoader cl) {
        do {
            if (!(cl instanceof DynamicClassLoader)) continue;
            return (DynamicClassLoader)cl;
        } while ((cl = cl.getParent()) != null);
        return null;
    }

    private void appendToClassPathForInstrumentation(String jarfile) throws IOException {
        this.add(Paths.get(jarfile, new String[0]).toRealPath(new LinkOption[0]).toUri().toURL());
    }

    static {
        DynamicClassLoader.registerAsParallelCapable();
    }
}

