/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.search;

import java.awt.Component;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.BinedModule;
import org.exbin.framework.bined.gui.BinEdComponentPanel;
import org.exbin.framework.bined.handler.CodeAreaPopupMenuHandler;
import org.exbin.framework.bined.preferences.BinaryEditorPreferences;
import org.exbin.framework.bined.search.BinarySearch;
import org.exbin.framework.bined.search.SearchCondition;
import org.exbin.framework.bined.search.SearchParameters;
import org.exbin.framework.bined.search.gui.BinarySearchPanel;
import org.exbin.framework.bined.search.service.BinarySearchService;
import org.exbin.framework.bined.search.service.impl.BinarySearchServiceImpl;

@ParametersAreNonnullByDefault
public class BinEdComponentSearch
implements BinEdComponentPanel.BinEdComponentExtension {
    private BinEdComponentPanel componentPanel;
    private final BinarySearch binarySearch = new BinarySearch();
    private BinarySearchService binarySearchService;
    private boolean binarySearchPanelVisible = false;
    private XBApplication application;

    public void onCreate(BinEdComponentPanel componentPanel) {
        this.componentPanel = componentPanel;
        ExtCodeArea codeArea = componentPanel.getCodeArea();
        this.binarySearchService = new BinarySearchServiceImpl(codeArea);
        this.binarySearch.setBinarySearchService(this.binarySearchService);
        this.binarySearch.setPanelClosingListener(this::hideSearchPanel);
        BinedModule binedModule = (BinedModule)this.application.getModuleRepository().getModuleByInterface(BinedModule.class);
        this.binarySearch.setCodeAreaPopupMenuHandler(binedModule.createCodeAreaPopupMenuHandler(BinedModule.PopupMenuVariant.NORMAL));
    }

    public void onDataChange() {
        if (this.binarySearchPanelVisible) {
            this.binarySearch.dataChanged();
        }
    }

    public void onUndoHandlerChange() {
    }

    public void onInitFromPreferences(BinaryEditorPreferences preferences) {
    }

    public void onClose() {
    }

    public void showSearchPanel(BinarySearchPanel.PanelMode panelMode) {
        if (!this.binarySearchPanelVisible) {
            this.componentPanel.add((Component)this.binarySearch.getPanel(), (Object)"South");
            this.componentPanel.revalidate();
            this.binarySearchPanelVisible = true;
            this.binarySearch.getPanel().requestSearchFocus();
        }
        this.binarySearch.getPanel().switchPanelMode(panelMode);
    }

    public void hideSearchPanel() {
        if (this.binarySearchPanelVisible) {
            this.binarySearch.cancelSearch();
            this.binarySearch.clearSearch();
            this.componentPanel.remove((Component)this.binarySearch.getPanel());
            this.componentPanel.revalidate();
            this.binarySearchPanelVisible = false;
        }
    }

    public void performSearchText(String text) {
        SearchParameters searchParameters = new SearchParameters();
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setSearchText(text);
        searchParameters.setCondition(searchCondition);
        this.binarySearchService.performFind(searchParameters, this.binarySearch.getSearchStatusListener());
    }

    public void performFindAgain() {
        if (this.binarySearchPanelVisible) {
            this.binarySearchService.performFindAgain(this.binarySearch.getSearchStatusListener());
        } else {
            this.showSearchPanel(BinarySearchPanel.PanelMode.FIND);
        }
    }

    public void setCodeAreaPopupMenuHandler(CodeAreaPopupMenuHandler codeAreaPopupMenuHandler) {
        this.binarySearch.getPanel().setCodeAreaPopupMenuHandler(codeAreaPopupMenuHandler);
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        this.binarySearch.setApplication(application);
    }
}

