/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.highlight.swing.extended;

import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.basic.BasicCodeAreaSection;
import org.exbin.bined.color.CodeAreaColorType;
import org.exbin.bined.highlight.swing.color.CodeAreaColorizationColorType;
import org.exbin.bined.highlight.swing.extended.ExtendedHighlightCodeAreaPainter;
import org.exbin.bined.swing.CodeAreaCore;

@ParametersAreNonnullByDefault
public class ExtendedHighlightNonAsciiCodeAreaPainter
extends ExtendedHighlightCodeAreaPainter {
    private Color controlCodes;
    private Color upperCodes;
    private Color textColor;
    private boolean nonAsciiHighlightingEnabled = true;

    public ExtendedHighlightNonAsciiCodeAreaPainter(CodeAreaCore codeArea) {
        super(codeArea);
        this.textColor = codeArea.getForeground();
        if (this.textColor == null) {
            this.textColor = Color.BLACK;
        }
        int controlCodesRed = this.textColor.getRed();
        int controlCodesRedDiff = 0;
        if (controlCodesRed > 32) {
            if (controlCodesRed > 192) {
                controlCodesRedDiff = controlCodesRed - 192;
            }
            controlCodesRed = 255;
        } else {
            controlCodesRed += 224;
        }
        int controlCodesBlue = this.textColor.getBlue();
        int controlCodesBlueDiff = 0;
        if (controlCodesBlue > 32) {
            if (controlCodesBlue > 192) {
                controlCodesBlueDiff = controlCodesBlue - 192;
            }
            controlCodesBlue = 255;
        } else {
            controlCodesBlue += 224;
        }
        this.controlCodes = new Color(controlCodesRed, this.downShift(this.textColor.getGreen(), controlCodesBlueDiff + controlCodesRedDiff), controlCodesBlue);
        int upperCodesGreen = this.textColor.getGreen();
        int upperCodesGreenDiff = 0;
        if (upperCodesGreen > 64) {
            if (upperCodesGreen > 192) {
                upperCodesGreenDiff = upperCodesGreen - 192;
            }
            upperCodesGreen = 255;
        } else {
            upperCodesGreen += 192;
        }
        int upperCodesBlue = this.textColor.getBlue();
        int upperCodesBlueDiff = 0;
        if (upperCodesBlue > 64) {
            if (upperCodesBlue > 192) {
                upperCodesBlueDiff = upperCodesBlue - 192;
            }
            upperCodesBlue = 255;
        } else {
            upperCodesBlue += 192;
        }
        this.upperCodes = new Color(this.downShift(this.textColor.getRed(), upperCodesGreenDiff + upperCodesBlueDiff), upperCodesGreen, upperCodesBlue);
    }

    private int downShift(int color, int diff) {
        if (color < diff) {
            return 0;
        }
        return color - diff;
    }

    @Override
    @Nullable
    public Color getPositionTextColor(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section, boolean unprintables) {
        long dataPosition;
        Color color = super.getPositionTextColor(rowDataPosition, byteOnRow, charOnRow, section, unprintables);
        if (this.nonAsciiHighlightingEnabled && section == BasicCodeAreaSection.CODE_MATRIX && (color == null || this.textColor.equals(color)) && (dataPosition = rowDataPosition + (long)byteOnRow) < this.codeArea.getDataSize()) {
            BinaryData contentData = this.codeArea.getContentData();
            byte value = contentData.getByte(dataPosition);
            if (value < 0) {
                Color upperCodesColor = this.getColorsProfile().getColor((CodeAreaColorType)CodeAreaColorizationColorType.UPPER_CODES_COLOR);
                color = upperCodesColor != null ? upperCodesColor : this.upperCodes;
            } else if (value < 32) {
                Color controlCodesColor = this.getColorsProfile().getColor((CodeAreaColorType)CodeAreaColorizationColorType.CONTROL_CODES_COLOR);
                color = controlCodesColor != null ? controlCodesColor : this.controlCodes;
            }
        }
        return color;
    }

    @Override
    @Nullable
    public Color getPositionBackgroundColor(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section, boolean unprintables) {
        long dataPosition;
        Color color = super.getPositionBackgroundColor(rowDataPosition, byteOnRow, charOnRow, section, unprintables);
        if (this.nonAsciiHighlightingEnabled && section == BasicCodeAreaSection.CODE_MATRIX && (color == null || this.textColor.equals(color)) && (dataPosition = rowDataPosition + (long)byteOnRow) < this.codeArea.getDataSize()) {
            Color controlCodesBackground;
            BinaryData contentData = this.codeArea.getContentData();
            byte value = contentData.getByte(dataPosition);
            if (value < 0) {
                Color upperCodesBackground = this.getColorsProfile().getColor((CodeAreaColorType)CodeAreaColorizationColorType.UPPER_CODES_BACKGROUND);
                if (upperCodesBackground != null) {
                    color = upperCodesBackground;
                }
            } else if (value < 32 && (controlCodesBackground = this.getColorsProfile().getColor((CodeAreaColorType)CodeAreaColorizationColorType.CONTROL_CODES_BACKGROUND)) != null) {
                color = controlCodesBackground;
            }
        }
        return color;
    }

    @Nonnull
    public Color getControlCodes() {
        return this.controlCodes;
    }

    public void setControlCodes(Color controlCodes) {
        this.controlCodes = controlCodes;
    }

    @Nonnull
    public Color getUpperCodes() {
        return this.upperCodes;
    }

    public void setUpperCodes(Color upperCodes) {
        this.upperCodes = upperCodes;
    }

    public boolean isNonAsciiHighlightingEnabled() {
        return this.nonAsciiHighlightingEnabled;
    }

    public void setNonAsciiHighlightingEnabled(boolean nonAsciiHighlightingEnabled) {
        this.nonAsciiHighlightingEnabled = nonAsciiHighlightingEnabled;
    }
}

