/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.operation.undo.gui;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractListModel;
import org.exbin.xbup.operation.Command;
import org.exbin.xbup.operation.undo.XBUndoHandler;

@ParametersAreNonnullByDefault
public class UndoManagerModel
extends AbstractListModel<String> {
    private XBUndoHandler undoHandler = null;

    @Nullable
    public XBUndoHandler getUndoHandler() {
        return this.undoHandler;
    }

    public void setUndoHandler(XBUndoHandler undoHandler) {
        if (this.undoHandler != null) {
            this.fireIntervalRemoved(this, 0, this.getList().size());
        }
        this.undoHandler = undoHandler;
        this.fireIntervalAdded(this, 0, this.getList().size());
    }

    @Override
    public int getSize() {
        return this.undoHandler == null ? 0 : this.getList().size() + 1;
    }

    @Override
    @Nullable
    public String getElementAt(int index) {
        return this.undoHandler == null ? null : (index == 0 ? "Initial" : this.getList().get(index - 1).getCaption()) + (this.undoHandler.getCommandPosition() == (long)index ? " (current)" : "") + (this.undoHandler.getSyncPoint() == (long)index ? " (saved)" : "");
    }

    @Nullable
    public Command getItem(int index) {
        return this.undoHandler == null || index == 0 ? null : this.getList().get(index - 1);
    }

    public int getCurrentPosition() {
        return (int)this.undoHandler.getCommandPosition();
    }

    @Nonnull
    private List<Command> getList() {
        return Objects.requireNonNull(this.undoHandler.getCommandList());
    }
}

