/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.about.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.exbin.framework.about.gui.AboutPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.CloseControlPanel;

@ParametersAreNonnullByDefault
public class AboutAction
extends AbstractAction {
    public static final String ACTION_ID = "aboutAction";
    private XBApplication application;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(AboutAction.class);
    private JComponent sideComponent = null;

    public AboutAction() {
        this.init();
    }

    private void init() {
        ActionUtils.setupAction((Action)this, (ResourceBundle)this.resourceBundle, (String)ACTION_ID);
        this.putValue("dialogMode", true);
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        AboutPanel aboutPanel = new AboutPanel();
        aboutPanel.setApplication(this.application);
        aboutPanel.setSideComponent(this.sideComponent);
        CloseControlPanel controlPanel = new CloseControlPanel();
        WindowUtils.DialogWrapper aboutDialog = frameModule.createDialog((JComponent)aboutPanel, (JPanel)controlPanel);
        ((JDialog)aboutDialog.getWindow()).setTitle(this.resourceBundle.getString("aboutAction.dialogTitle"));
        controlPanel.setHandler(() -> ((WindowUtils.DialogWrapper)aboutDialog).close());
        aboutDialog.showCentered((Component)e.getSource());
        aboutDialog.dispose();
    }

    public void setAboutDialogSideComponent(JComponent sideComponent) {
        this.sideComponent = sideComponent;
    }
}

