/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.property.gui;

import java.awt.Component;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.xbup.catalog.item.plugin.gui.CatalogSelectUiPanelViewerPanel;
import org.exbin.framework.xbup.catalog.item.property.gui.CatalogPropertyTableCellPanel;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBEBlockRev;
import org.exbin.xbup.catalog.entity.XBEXBlockUi;
import org.exbin.xbup.catalog.entity.XBEXPlugUi;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBPlugUiType;
import org.exbin.xbup.core.catalog.base.XBCBlockRev;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCXBlockUi;
import org.exbin.xbup.core.catalog.base.XBCXPlugUi;
import org.exbin.xbup.core.catalog.base.service.XBCRevService;
import org.exbin.xbup.core.catalog.base.service.XBCXUiService;

public class CatalogPViewerPropertyTableCellPanel
extends CatalogPropertyTableCellPanel {
    private XBApplication application;
    private XBACatalog catalog;
    private long paneId;
    private XBCBlockRev blockRev;
    private XBCXPlugUi plugUi;

    public CatalogPViewerPropertyTableCellPanel(XBACatalog catalog) {
        this.catalog = catalog;
        this.init();
    }

    private void init() {
        this.setEditorAction(e -> this.performEditorAction());
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void performEditorAction() {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        CatalogSelectUiPanelViewerPanel panelSelectPanel = new CatalogSelectUiPanelViewerPanel();
        panelSelectPanel.setApplication(this.application);
        panelSelectPanel.setCatalog(this.catalog);
        panelSelectPanel.setPlugUi(this.plugUi);
        DefaultControlPanel controlPanel = new DefaultControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)panelSelectPanel, (JPanel)controlPanel);
        controlPanel.setHandler(actionType -> {
            switch (actionType) {
                case OK: {
                    this.plugUi = panelSelectPanel.getPlugUi();
                    XBEXBlockUi blockPane = new XBEXBlockUi();
                    blockPane.setBlockRev((XBCBlockRev)((XBEBlockRev)this.blockRev));
                    blockPane.setUi((XBCXPlugUi)((XBEXPlugUi)this.plugUi));
                    blockPane.setPriority(0L);
                    EntityManager em = ((XBECatalog)this.catalog).getEntityManager();
                    EntityTransaction transaction = em.getTransaction();
                    transaction.begin();
                    em.persist((Object)blockPane);
                    em.flush();
                    transaction.commit();
                    this.paneId = blockPane.getId();
                    this.setPropertyLabel();
                    break;
                }
            }
            dialog.close();
        });
        dialog.showCentered((Component)((Object)this));
        dialog.dispose();
    }

    public void setCatalogItem(XBCItem catalogItem) {
        XBCXUiService uiService = (XBCXUiService)this.catalog.getCatalogService(XBCXUiService.class);
        XBCRevService revService = (XBCRevService)this.catalog.getCatalogService(XBCRevService.class);
        long maxRev = revService.findMaxRevXB((XBCSpec)((XBCBlockSpec)catalogItem));
        this.blockRev = (XBCBlockRev)revService.findRevByXB((XBCSpec)((XBCBlockSpec)catalogItem), maxRev);
        XBCXBlockUi blockUi = uiService.findUiByPR(this.blockRev, XBPlugUiType.PANEL_VIEWER, 0L);
        this.plugUi = blockUi == null ? null : blockUi.getUi();
        this.paneId = blockUi == null ? 0L : blockUi.getId();
        this.setPropertyLabel();
    }

    private void setPropertyLabel() {
        this.setPropertyText(this.paneId > 0L ? String.valueOf(this.paneId) : "");
    }

    public long getPaneId() {
        return this.paneId;
    }

    public XBACatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }
}

