/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.property.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.visual.xbplugins.XBPicturePanel;

@ParametersAreNonnullByDefault
public class CatalogEditIconPanel
extends JPanel {
    private byte[] icon;
    private final XBPicturePanel mainPanel;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CatalogEditIconPanel.class);

    public CatalogEditIconPanel(XBACatalog catalog, byte[] icon) {
        this.icon = icon;
        this.initComponents();
        this.mainPanel = new XBPicturePanel();
        this.add((Component)this.mainPanel, "Center");
        this.mainPanel.setIcon((Icon)(icon != null ? new ImageIcon(icon) : null));
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogEditIconPanel(null, null));
    }

    public byte[] getIcon() {
        Icon imageIcon = this.mainPanel.getIcon();
        if (imageIcon != null) {
            ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)XBPicturePanel.toBufferedImage((Image)((ImageIcon)imageIcon).getImage()), "png", arrayOutputStream);
                this.icon = arrayOutputStream.toByteArray();
            }
            catch (IOException ex) {
                Logger.getLogger(CatalogEditIconPanel.class.getName()).log(Level.SEVERE, null, ex);
                this.icon = null;
            }
        } else {
            this.icon = null;
        }
        return this.icon;
    }
}

