/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.plugin.ation;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;
import org.exbin.framework.xbup.catalog.item.plugin.gui.CatalogEditNodePluginPanel;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBEXFile;
import org.exbin.xbup.catalog.entity.XBEXPlugUi;
import org.exbin.xbup.catalog.entity.XBEXPlugUiType;
import org.exbin.xbup.catalog.entity.XBEXPlugin;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBPlugUiType;
import org.exbin.xbup.core.catalog.base.XBCXFile;
import org.exbin.xbup.core.catalog.base.XBCXPlugUiType;
import org.exbin.xbup.core.catalog.base.XBCXPlugin;
import org.exbin.xbup.core.catalog.base.service.XBCXUiService;

@ParametersAreNonnullByDefault
public class EditItemPluginAction
extends AbstractAction {
    public static final String ACTION_ID = "editCatalogItemPluginAction";
    private XBApplication application;
    private XBACatalog catalog;
    private Component parentComponent;
    private XBCXPlugin currentPlugin;
    private String resultName;
    private byte[] resultData;

    public void setup(XBApplication application) {
        this.application = application;
    }

    @Nullable
    public XBCXPlugin getCurrentPlugin() {
        return this.currentPlugin;
    }

    public void setCurrentPlugin(XBCXPlugin currentPlugin) {
        this.currentPlugin = currentPlugin;
    }

    @Nullable
    public String getResultName() {
        return this.resultName;
    }

    @Nullable
    public byte[] getResultData() {
        return this.resultData;
    }

    public void setParentComponent(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    @Override
    public void actionPerformed(@Nullable ActionEvent event) {
        this.resultName = null;
        this.resultData = null;
        XBCXUiService uiService = (XBCXUiService)this.catalog.getCatalogService(XBCXUiService.class);
        long rowEditorsCount = uiService.getPlugUisCount(this.currentPlugin, XBPlugUiType.ROW_EDITOR);
        long panelViewersCount = uiService.getPlugUisCount(this.currentPlugin, XBPlugUiType.PANEL_VIEWER);
        long panelEditorsCount = uiService.getPlugUisCount(this.currentPlugin, XBPlugUiType.PANEL_EDITOR);
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        CatalogEditNodePluginPanel editPanel = new CatalogEditNodePluginPanel();
        editPanel.setApplication(this.application);
        editPanel.setCatalog(this.catalog);
        editPanel.setPlugin(this.currentPlugin);
        editPanel.setRowEditorsCount(rowEditorsCount);
        editPanel.setPanelViewersCount(panelViewersCount);
        editPanel.setPanelEditorsCount(panelEditorsCount);
        DefaultControlPanel controlPanel = new DefaultControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)editPanel, (JPanel)controlPanel);
        frameModule.setDialogTitle(dialog, editPanel.getResourceBundle());
        controlPanel.setHandler(actionType -> {
            if (actionType == DefaultControlHandler.ControlActionType.OK) {
                XBEXPlugUi plugUi;
                long i;
                XBEXPlugin plugin = (XBEXPlugin)editPanel.getPlugin();
                XBCXFile file = editPanel.getFile();
                long updatedRowEditorsCount = editPanel.getRowEditorsCount();
                long updatedPanelViewersCount = editPanel.getPanelViewersCount();
                long updatedPanelEditorsCount = editPanel.getPanelEditorsCount();
                plugin.setPluginFile((XBCXFile)((XBEXFile)file));
                EntityManager em = ((XBECatalog)this.catalog).getEntityManager();
                EntityTransaction transaction = em.getTransaction();
                transaction.begin();
                em.persist((Object)plugin);
                if (updatedRowEditorsCount > rowEditorsCount) {
                    XBEXPlugUiType rowEditorType = (XBEXPlugUiType)uiService.findTypeById(XBPlugUiType.ROW_EDITOR.getDbIndex());
                    for (i = rowEditorsCount; i < updatedRowEditorsCount; ++i) {
                        plugUi = new XBEXPlugUi();
                        plugUi.setPlugin((XBCXPlugin)plugin);
                        plugUi.setUiType((XBCXPlugUiType)rowEditorType);
                        plugUi.setMethodIndex(i);
                        em.persist((Object)plugUi);
                    }
                } else {
                    for (long i2 = rowEditorsCount - 1L; i2 >= updatedRowEditorsCount; --i2) {
                        em.remove((Object)uiService.getPlugUi((XBCXPlugin)plugin, XBPlugUiType.ROW_EDITOR, i2));
                    }
                }
                if (updatedPanelViewersCount > panelViewersCount) {
                    XBEXPlugUiType uiType = (XBEXPlugUiType)uiService.findTypeById(XBPlugUiType.PANEL_VIEWER.getDbIndex());
                    for (i = panelViewersCount; i < updatedPanelViewersCount; ++i) {
                        plugUi = new XBEXPlugUi();
                        plugUi.setPlugin((XBCXPlugin)plugin);
                        plugUi.setUiType((XBCXPlugUiType)uiType);
                        plugUi.setMethodIndex(i);
                        em.persist((Object)plugUi);
                    }
                } else {
                    for (long i3 = panelViewersCount - 1L; i3 >= updatedPanelViewersCount; --i3) {
                        em.remove((Object)uiService.getPlugUi((XBCXPlugin)plugin, XBPlugUiType.PANEL_VIEWER, i3));
                    }
                }
                if (updatedPanelEditorsCount > panelEditorsCount) {
                    XBEXPlugUiType uiType = (XBEXPlugUiType)uiService.findTypeById(XBPlugUiType.PANEL_EDITOR.getDbIndex());
                    for (i = panelEditorsCount; i < updatedPanelEditorsCount; ++i) {
                        plugUi = new XBEXPlugUi();
                        plugUi.setPlugin((XBCXPlugin)plugin);
                        plugUi.setUiType((XBCXPlugUiType)uiType);
                        plugUi.setMethodIndex(i);
                        em.persist((Object)plugUi);
                    }
                } else {
                    for (long i4 = panelEditorsCount - 1L; i4 >= updatedPanelEditorsCount; --i4) {
                        em.remove((Object)uiService.getPlugUi((XBCXPlugin)plugin, XBPlugUiType.PANEL_EDITOR, i4));
                    }
                }
                em.flush();
                transaction.commit();
            }
            dialog.close();
        });
        dialog.showCentered(this.parentComponent);
        dialog.dispose();
    }

    public void setCatalog(@Nullable XBACatalog catalog) {
        this.catalog = catalog;
    }
}

