/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.exbin.framework.action.api.MenuManagement;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.data.model.CatalogDefsTableModel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.xbup.catalog.item.file.CatalogFilesEditor;
import org.exbin.framework.xbup.catalog.item.plugin.CatalogPluginsEditor;
import org.exbin.framework.xbup.catalog.item.property.CatalogPropertiesEditor;
import org.exbin.framework.xbup.catalog.item.revision.CatalogRevisionsEditor;
import org.exbin.framework.xbup.catalog.item.spec.CatalogDefinitionEditor;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCSpec;

@ParametersAreNonnullByDefault
public class CatalogEditItemPanel
extends JPanel {
    private XBApplication application;
    private XBACatalog catalog;
    private CatalogPropertiesEditor propertiesEditor;
    private CatalogRevisionsEditor revisionsEditor;
    private CatalogDefinitionEditor definitionEditor;
    private CatalogFilesEditor catalogFilesEditor;
    private CatalogPluginsEditor catalogPluginsEditor;
    private MenuManagement menuManagement;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CatalogEditItemPanel.class);
    private JTabbedPane mainTabbedPane;

    public CatalogEditItemPanel() {
        this.initComponents();
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setCatalogItem(XBCItem item) {
        this.mainTabbedPane.removeAll();
        this.propertiesEditor = new CatalogPropertiesEditor();
        this.propertiesEditor.setApplication(this.application);
        this.propertiesEditor.setCatalog(this.catalog);
        this.propertiesEditor.setItem(item);
        this.mainTabbedPane.add((Component)this.propertiesEditor.getCatalogEditorPanel(), "Basic");
        if (item instanceof XBCSpec) {
            this.revisionsEditor = new CatalogRevisionsEditor();
            this.revisionsEditor.setApplication(this.application);
            this.revisionsEditor.setCatalog(this.catalog);
            this.revisionsEditor.setCatalogItem(item);
            this.mainTabbedPane.add((Component)this.revisionsEditor.getCatalogEditorPanel(), "Revisions");
            this.definitionEditor = new CatalogDefinitionEditor();
            CatalogDefsTableModel defsTableModel = new CatalogDefsTableModel();
            defsTableModel.setCatalog(this.catalog);
            defsTableModel.setCatalogItem(item);
            this.definitionEditor.setApplication(this.application);
            this.definitionEditor.setCatalog(this.catalog);
            this.definitionEditor.setCatalogItem(item);
            this.definitionEditor.setDefsModel(defsTableModel);
            this.revisionsEditor.setDefsModel(defsTableModel);
            this.mainTabbedPane.add((Component)this.definitionEditor.getCatalogEditorPanel(), "Definition");
        } else if (item instanceof XBCNode) {
            this.catalogFilesEditor = new CatalogFilesEditor();
            this.catalogFilesEditor.setApplication(this.application);
            this.catalogFilesEditor.setCatalog(this.catalog);
            this.catalogFilesEditor.setNode((XBCNode)item);
            if (this.menuManagement != null) {
                this.catalogFilesEditor.setMenuManagement(this.menuManagement);
            }
            this.mainTabbedPane.add((Component)this.catalogFilesEditor.getCatalogEditorPanel(), "Files");
            this.catalogPluginsEditor = new CatalogPluginsEditor();
            this.catalogPluginsEditor.setApplication(this.application);
            this.catalogPluginsEditor.setCatalog(this.catalog);
            this.catalogPluginsEditor.setNode((XBCNode)item);
            if (this.menuManagement != null) {
                this.catalogPluginsEditor.setMenuManagement(this.menuManagement);
            }
            this.mainTabbedPane.add((Component)this.catalogPluginsEditor.getCatalogEditorPanel(), "Plugins");
        }
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        if (this.propertiesEditor != null) {
            this.propertiesEditor.setApplication(application);
        }
        if (this.revisionsEditor != null) {
            this.revisionsEditor.setApplication(application);
        }
        if (this.definitionEditor != null) {
            this.definitionEditor.setApplication(application);
        }
        if (this.catalogFilesEditor != null) {
            this.catalogFilesEditor.setApplication(application);
        }
    }

    public void persist() {
        this.propertiesEditor.persist();
        if (this.definitionEditor != null) {
            this.definitionEditor.persist();
        }
        if (this.revisionsEditor != null) {
            this.revisionsEditor.persist();
        }
        if (this.catalogFilesEditor != null) {
            this.catalogFilesEditor.persist();
        }
    }

    public void setMenuManagement(MenuManagement menuManagement) {
        this.menuManagement = menuManagement;
        if (this.catalogFilesEditor != null) {
            this.catalogFilesEditor.setMenuManagement(menuManagement);
        }
    }

    public XBCItem getCatalogItem() {
        return this.propertiesEditor.getItem();
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        if (this.propertiesEditor != null) {
            this.propertiesEditor.setCatalog(catalog);
        }
        if (this.revisionsEditor != null) {
            this.revisionsEditor.setCatalog(catalog);
        }
        if (this.definitionEditor != null) {
            this.definitionEditor.setCatalog(catalog);
        }
        if (this.catalogFilesEditor != null) {
            this.catalogFilesEditor.setCatalog(catalog);
        }
    }

    private void initComponents() {
        this.mainTabbedPane = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainTabbedPane, "Center");
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogEditItemPanel());
    }
}

