/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.action;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.action.api.MenuManagement;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;
import org.exbin.framework.xbup.catalog.item.gui.CatalogEditItemPanel;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCItem;

@ParametersAreNonnullByDefault
public class EditCatalogItemAction
extends AbstractAction {
    public static final String ACTION_ID = "editCatalogItemAction";
    private XBApplication application;
    private XBACatalog catalog;
    private Component parentComponent;
    private XBCItem currentItem;
    private XBCItem resultItem;
    private MenuManagement menuManagement;

    public void setup(XBApplication application) {
        this.application = application;
    }

    @Nullable
    public XBCItem getCurrentItem() {
        return this.currentItem;
    }

    public void setCurrentItem(@Nullable XBCItem currentItem) {
        this.currentItem = currentItem;
    }

    @Nullable
    public XBCItem getResultItem() {
        return this.resultItem;
    }

    public void setParentComponent(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    @Override
    public void actionPerformed(@Nullable ActionEvent event) {
        this.resultItem = null;
        if (this.currentItem != null) {
            FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
            CatalogEditItemPanel editPanel = new CatalogEditItemPanel();
            editPanel.setApplication(this.application);
            editPanel.setMenuManagement(this.menuManagement);
            editPanel.setCatalog(this.catalog);
            editPanel.setCatalogItem(this.currentItem);
            editPanel.setVisible(true);
            DefaultControlPanel controlPanel = new DefaultControlPanel();
            WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)editPanel, (JPanel)controlPanel);
            WindowUtils.addHeaderPanel((Window)dialog.getWindow(), editPanel.getClass(), (ResourceBundle)editPanel.getResourceBundle());
            frameModule.setDialogTitle(dialog, editPanel.getResourceBundle());
            controlPanel.setHandler(actionType -> {
                if (actionType == DefaultControlHandler.ControlActionType.OK) {
                    EntityManager em = ((XBECatalog)this.catalog).getEntityManager();
                    EntityTransaction transaction = em.getTransaction();
                    transaction.begin();
                    editPanel.persist();
                    em.flush();
                    transaction.commit();
                    this.resultItem = this.currentItem;
                }
                dialog.close();
            });
            dialog.showCentered(this.parentComponent);
            dialog.dispose();
        }
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    public void setMenuManagement(MenuManagement menuManagement) {
        this.menuManagement = menuManagement;
    }
}

