/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.property.gui;

import java.awt.Component;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.RemovalControlPanel;
import org.exbin.framework.xbup.catalog.item.property.gui.CatalogEditDocumentationPanel;
import org.exbin.framework.xbup.catalog.item.property.gui.CatalogPropertyTableCellPanel;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.service.XBCXHDocService;

@ParametersAreNonnullByDefault
public class CatalogDocPropertyTableCellPanel
extends CatalogPropertyTableCellPanel {
    private XBApplication application;
    private XBACatalog catalog;
    private String doc;

    public CatalogDocPropertyTableCellPanel(XBACatalog catalog) {
        this.catalog = catalog;
        this.init();
    }

    private void init() {
        this.setEditorAction(e -> this.performEditorAction());
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void performEditorAction() {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        CatalogEditDocumentationPanel docPanel = new CatalogEditDocumentationPanel();
        docPanel.setDocumentation(this.doc);
        RemovalControlPanel controlPanel = new RemovalControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)docPanel, (JPanel)controlPanel);
        frameModule.setDialogTitle(dialog, docPanel.getResourceBundle());
        controlPanel.setHandler(actionType -> {
            switch (actionType) {
                case OK: {
                    this.doc = docPanel.getDocumentation();
                    this.setDocLabel();
                    break;
                }
                case CANCEL: {
                    break;
                }
                case REMOVE: {
                    this.doc = "";
                    this.setDocLabel();
                }
            }
            dialog.close();
        });
        dialog.showCentered((Component)((Object)this));
        dialog.dispose();
    }

    public void setCatalogItem(XBCItem catalogItem) {
        XBCXHDocService hDocService = (XBCXHDocService)this.catalog.getCatalogService(XBCXHDocService.class);
        this.doc = hDocService.getDocumentationText(catalogItem);
        this.setDocLabel();
    }

    private void setDocLabel() {
        this.setPropertyText(this.doc == null || this.doc.isEmpty() ? "" : "[" + this.doc.length() + " bytes]");
    }

    public String getDocument() {
        return this.doc;
    }

    public XBACatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }
}

