/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.plugin;

import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.exbin.framework.action.api.MenuManagement;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.component.action.DefaultEditItemActions;
import org.exbin.framework.component.api.ActionsProvider;
import org.exbin.framework.component.api.toolbar.EditItemActionsHandler;
import org.exbin.framework.component.api.toolbar.EditItemActionsUpdateListener;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.xbup.catalog.item.plugin.ation.AddItemPluginAction;
import org.exbin.framework.xbup.catalog.item.plugin.ation.EditItemPluginAction;
import org.exbin.framework.xbup.catalog.item.plugin.gui.CatalogItemEditPluginsPanel;
import org.exbin.framework.xbup.catalog.item.plugin.gui.CatalogPluginsTableModel;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCXPlugin;

@ParametersAreNonnullByDefault
public class CatalogPluginsEditor {
    private final CatalogItemEditPluginsPanel catalogEditorPanel;
    private final DefaultEditItemActions editActions;
    private XBApplication application;
    private XBACatalog catalog;
    private JPopupMenu popupMenu;
    private XBCNode node;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CatalogPluginsEditor.class);
    private AddItemPluginAction addPluginAction = new AddItemPluginAction();
    private EditItemPluginAction editPluginAction = new EditItemPluginAction();

    public CatalogPluginsEditor() {
        this.catalogEditorPanel = new CatalogItemEditPluginsPanel();
        this.editActions = new DefaultEditItemActions(DefaultEditItemActions.Mode.DIALOG);
        this.editActions.setEditItemActionsHandler(new EditItemActionsHandler(){

            public void performAddItem() {
                CatalogPluginsEditor.this.addPluginAction.setCurrentNode(CatalogPluginsEditor.this.node);
                CatalogPluginsEditor.this.addPluginAction.actionPerformed(null);
                AddItemPluginAction.ResultData resultData = CatalogPluginsEditor.this.addPluginAction.getResultData();
                if (resultData != null) {
                    CatalogPluginsTableModel pluginsModel = CatalogPluginsEditor.this.catalogEditorPanel.getPluginsModel();
                    pluginsModel.addItem((XBCXPlugin)resultData.plugin, resultData.file, resultData.rowEditorsCount, resultData.panelViewersCount, resultData.panelEditorsCount);
                }
            }

            public void performEditItem() {
                CatalogPluginsEditor.this.editPluginAction.setCurrentPlugin(CatalogPluginsEditor.this.catalogEditorPanel.getSelectedPlugin());
                CatalogPluginsEditor.this.editPluginAction.actionPerformed(null);
            }

            public void performDeleteItem() {
            }

            public boolean canAddItem() {
                return true;
            }

            public boolean canEditItem() {
                XBCXPlugin plugin = CatalogPluginsEditor.this.catalogEditorPanel.getSelectedPlugin();
                return plugin != null;
            }

            public boolean canDeleteItem() {
                return false;
            }

            public void setUpdateListener(@Nonnull EditItemActionsUpdateListener updateListener) {
                CatalogPluginsEditor.this.catalogEditorPanel.addSelectionListener(updateListener);
            }
        });
        this.addPluginAction.setParentComponent(this.catalogEditorPanel);
        this.editPluginAction.setParentComponent(this.catalogEditorPanel);
        this.popupMenu = new JPopupMenu();
        JMenuItem addPluginMenuItem = ActionUtils.actionToMenuItem((Action)this.editActions.getAddItemAction());
        addPluginMenuItem.setText(this.resourceBundle.getString("addPluginMenuItem.text") + "...");
        this.popupMenu.add(addPluginMenuItem);
        JMenuItem editPluginMenuItem = ActionUtils.actionToMenuItem((Action)this.editActions.getEditItemAction());
        editPluginMenuItem.setText(this.resourceBundle.getString("editPluginMenuItem.text") + "...");
        this.popupMenu.add(editPluginMenuItem);
        this.catalogEditorPanel.setPanelPopup(this.popupMenu);
        this.catalogEditorPanel.addFileActions((ActionsProvider)this.editActions);
    }

    @Nonnull
    public CatalogItemEditPluginsPanel getCatalogEditorPanel() {
        return this.catalogEditorPanel;
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        this.catalogEditorPanel.setApplication(application);
        this.addPluginAction.setup(application);
        this.editPluginAction.setup(application);
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.catalogEditorPanel.setCatalog(catalog);
        this.addPluginAction.setCatalog(catalog);
        this.editPluginAction.setCatalog(catalog);
    }

    public void setNode(XBCNode node) {
        this.node = node;
        this.catalogEditorPanel.setNode(node);
    }

    public void setMenuManagement(MenuManagement menuManagement) {
    }
}

