/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.file.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;
import org.exbin.framework.xbup.catalog.item.gui.CatalogItemType;
import org.exbin.framework.xbup.catalog.item.spec.gui.CatalogSelectSpecPanel;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCXFile;
import org.exbin.xbup.core.catalog.base.service.XBCNodeService;
import org.exbin.xbup.core.catalog.base.service.XBCXFileService;

@ParametersAreNonnullByDefault
public class CatalogSelectFilePanel
extends JPanel {
    private XBACatalog catalog;
    private XBApplication application;
    private List<XBCXFile> files = new ArrayList<XBCXFile>();
    private JLabel filesLabel;
    private JList<String> filesList;
    private JScrollPane filesScrollPane;
    private JLabel nodeLabel;
    private JButton nodeSelectButton;
    private JTextField nodeTextField;

    public CatalogSelectFilePanel() {
        this.initComponents();
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    public void setNode(XBCNode node) {
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        this.nodeTextField.setText(String.valueOf(node.getId()));
        XBCXFileService fileService = (XBCXFileService)this.catalog.getCatalogService(XBCXFileService.class);
        this.files = fileService.findFilesForNode(node);
        DefaultListModel model = (DefaultListModel)this.filesList.getModel();
        model.removeAllElements();
        if (this.files != null) {
            for (XBCXFile file : this.files) {
                model.addElement(file.getFilename());
            }
        }
    }

    @Nonnull
    public Optional<XBCXFile> getFile() {
        int selectedIndex = this.filesList.getSelectedIndex();
        return selectedIndex < 0 ? Optional.empty() : Optional.of(this.files.get(selectedIndex));
    }

    private void initComponents() {
        this.nodeLabel = new JLabel();
        this.nodeTextField = new JTextField();
        this.nodeSelectButton = new JButton();
        this.filesLabel = new JLabel();
        this.filesScrollPane = new JScrollPane();
        this.filesList = new JList();
        this.nodeLabel.setText("Node");
        this.nodeSelectButton.setText("Select...");
        this.nodeSelectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogSelectFilePanel.this.nodeSelectButtonActionPerformed(evt);
            }
        });
        this.filesLabel.setText("Files");
        this.filesList.setModel(new DefaultListModel());
        this.filesList.setSelectionMode(0);
        this.filesScrollPane.setViewportView(this.filesList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filesScrollPane).addGroup(layout.createSequentialGroup().addComponent(this.nodeTextField, -1, 293, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nodeSelectButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nodeLabel).addComponent(this.filesLabel)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.nodeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nodeTextField, -2, -1, -2).addComponent(this.nodeSelectButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filesScrollPane, -1, 209, Short.MAX_VALUE).addContainerGap()));
    }

    private void nodeSelectButtonActionPerformed(ActionEvent evt) {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        CatalogSelectSpecPanel selectPanel = new CatalogSelectSpecPanel(CatalogItemType.NODE);
        selectPanel.setCatalog(this.catalog);
        DefaultControlPanel controlPanel = new DefaultControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)selectPanel, (JPanel)controlPanel);
        controlPanel.setHandler(actionType -> {
            if (actionType == DefaultControlHandler.ControlActionType.OK) {
                XBCNode node = (XBCNode)selectPanel.getSpec();
                this.setNode(node);
            }
            dialog.close();
        });
        dialog.showCentered((Component)this);
        dialog.dispose();
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogSelectFilePanel());
    }
}

