/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.file.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.component.api.ActionsProvider;
import org.exbin.framework.component.api.toolbar.EditItemActionsUpdateListener;
import org.exbin.framework.component.gui.ToolBarSidePanel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.xbup.catalog.item.file.gui.CatalogFilesTableModel;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCXFile;
import org.exbin.xbup.core.catalog.base.service.XBCXFileService;

@ParametersAreNonnullByDefault
public class CatalogItemEditFilesPanel
extends JPanel {
    private XBApplication application;
    private XBACatalog catalog;
    private XBCXFileService fileService;
    private final CatalogFilesTableModel filesModel;
    private XBCNode currentNode;
    private final ToolBarSidePanel toolBarPanel = new ToolBarSidePanel();
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CatalogItemEditFilesPanel.class);
    private JScrollPane catalogFilesListScrollPane;
    private JTable catalogFilesListTable;

    public CatalogItemEditFilesPanel() {
        this.filesModel = new CatalogFilesTableModel();
        this.initComponents();
        this.toolBarPanel.setToolBarPosition(ToolBarSidePanel.ToolBarPosition.RIGHT);
        this.toolBarPanel.add((Component)this.catalogFilesListScrollPane, (Object)"Center");
        this.add((Component)this.toolBarPanel, "Center");
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void addFileActions(ActionsProvider actionsProvider) {
        this.toolBarPanel.addActions(actionsProvider);
    }

    @Nonnull
    public CatalogFilesTableModel getFilesModel() {
        return this.filesModel;
    }

    private void initComponents() {
        this.catalogFilesListScrollPane = new JScrollPane();
        this.catalogFilesListTable = new JTable();
        this.catalogFilesListScrollPane.setName("catalogFilesListScrollPane");
        this.catalogFilesListTable.setModel(this.filesModel);
        this.catalogFilesListTable.setName("catalogFilesListTable");
        this.catalogFilesListTable.setSelectionMode(0);
        this.catalogFilesListScrollPane.setViewportView(this.catalogFilesListTable);
        this.setName("Form");
        this.setLayout(new BorderLayout());
    }

    public void setNode(XBCNode node) {
        this.currentNode = node;
        this.filesModel.setNode(node);
        this.catalogFilesListTable.revalidate();
    }

    @Nullable
    public XBCXFile getSelectedFile() {
        int selectedRow = this.catalogFilesListTable.getSelectedRow();
        if (selectedRow >= 0) {
            return this.filesModel.getItem(selectedRow);
        }
        return null;
    }

    public int getSelectedIndex() {
        return this.catalogFilesListTable.getSelectedRow();
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogItemEditFilesPanel());
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.fileService = catalog == null ? null : (XBCXFileService)catalog.getCatalogService(XBCXFileService.class);
        this.filesModel.setCatalog((XBCatalog)catalog);
    }

    public void persist() {
        this.filesModel.persist();
    }

    public void setPanelPopup(JPopupMenu popupMenu) {
        this.catalogFilesListTable.setComponentPopupMenu(popupMenu);
    }

    public void addSelectionListener(EditItemActionsUpdateListener updateListener) {
        this.catalogFilesListTable.getSelectionModel().addListSelectionListener(e -> updateListener.stateChanged());
    }
}

