/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.file.gui;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.table.AbstractTableModel;
import org.exbin.xbup.catalog.entity.XBENode;
import org.exbin.xbup.catalog.entity.XBEXFile;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.XBCBase;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCXFile;
import org.exbin.xbup.core.catalog.base.service.XBCXFileService;

@ParametersAreNonnullByDefault
public class CatalogFilesTableModel
extends AbstractTableModel {
    private XBCatalog catalog;
    private XBCXFileService fileService;
    private XBCNode node = null;
    private final String[] columnNames = new String[]{"Filename", "Size"};
    private final Class[] columnClasses = new Class[]{String.class, Long.class};
    private List<FileItemRecord> items = new ArrayList<FileItemRecord>();

    @Override
    public int getRowCount() {
        return this.items.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.items.get((int)rowIndex).fileName;
            }
            case 1: {
                byte[] data = this.items.get((int)rowIndex).modifiedData;
                if (data == null) {
                    data = this.items.get((int)rowIndex).file.getContent();
                }
                return data == null ? 0 : data.length;
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClasses[columnIndex];
    }

    @Nullable
    public XBCNode getNode() {
        return this.node;
    }

    public void setNode(@Nullable XBCNode node) {
        this.node = node;
        this.items = new ArrayList<FileItemRecord>();
        if (node != null) {
            for (XBCXFile file : this.fileService.findFilesForNode(node)) {
                this.items.add(new FileItemRecord(file));
            }
        }
    }

    public XBCXFile getItem(int rowIndex) {
        return this.items.get((int)rowIndex).file;
    }

    public void addItem(String fileName, byte[] data) {
        this.items.add(new FileItemRecord(fileName, data));
        this.fireTableDataChanged();
    }

    public XBCXFile removeItem(int rowIndex) {
        XBCXFile result = this.items.remove((int)rowIndex).file;
        this.fireTableDataChanged();
        return result;
    }

    public void setCatalog(@Nullable XBCatalog catalog) {
        this.catalog = catalog;
        this.fileService = catalog == null ? null : (XBCXFileService)catalog.getCatalogService(XBCXFileService.class);
    }

    public void persist() {
        for (FileItemRecord itemRecord : this.items) {
            if (itemRecord.file == null) {
                XBEXFile file = new XBEXFile();
                file.setNode((XBCNode)((XBENode)this.node));
                file.setFilename(itemRecord.fileName);
                itemRecord.file = file;
            }
            if (itemRecord.modifiedData == null) continue;
            ((XBEXFile)itemRecord.file).setContent(itemRecord.modifiedData);
            this.fileService.persistItem((XBCBase)itemRecord.file);
        }
    }

    public void setItemData(int rowIndex, byte[] fileContent) {
        this.items.get((int)rowIndex).modifiedData = fileContent;
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public void setFileName(int selectedRow, String fileName) {
        this.items.get((int)selectedRow).fileName = fileName;
        this.fireTableRowsUpdated(selectedRow, selectedRow);
    }

    @ParametersAreNonnullByDefault
    private static class FileItemRecord {
        XBCXFile file = null;
        String fileName = null;
        byte[] modifiedData = null;

        public FileItemRecord(String fileName, byte[] data) {
            this.fileName = fileName;
            this.modifiedData = data;
        }

        public FileItemRecord(XBCXFile file) {
            this.file = file;
            this.fileName = file.getFilename();
        }
    }
}

