/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.file.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCXFile;

@ParametersAreNonnullByDefault
public class ReplaceFileContentAction
extends AbstractAction {
    public static final String ACTION_ID = "replaceCatalogItemFileContentAction";
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ReplaceFileContentAction.class);
    private XBApplication application;
    private XBACatalog catalog;
    private Component parentComponent;
    private XBCXFile currentFile;
    private String resultName;
    private byte[] resultData;

    public void setup(XBApplication application) {
        this.application = application;
        ActionUtils.setupAction((Action)this, (ResourceBundle)this.resourceBundle, (String)ACTION_ID);
        this.putValue("dialogMode", true);
    }

    @Nullable
    public XBCXFile getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(XBCXFile currentFile) {
        this.currentFile = currentFile;
    }

    @Nullable
    public String getResultName() {
        return this.resultName;
    }

    @Nullable
    public byte[] getResultData() {
        return this.resultData;
    }

    public void setParentComponent(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    @Override
    public void actionPerformed(@Nullable ActionEvent event) {
        JFileChooser importFileChooser;
        this.resultName = null;
        this.resultData = null;
        if (this.currentFile != null && (importFileChooser = new JFileChooser()).showOpenDialog(this.parentComponent) == 0) {
            try {
                FileInputStream fileStream = new FileInputStream(importFileChooser.getSelectedFile().getAbsolutePath());
                byte[] fileData = new byte[(int)new File(importFileChooser.getSelectedFile().getAbsolutePath()).length()];
                DataInputStream dataIs = new DataInputStream(fileStream);
                dataIs.readFully(fileData);
                this.resultName = importFileChooser.getSelectedFile().getName();
                this.resultData = fileData;
            }
            catch (FileNotFoundException fileData) {
            }
            catch (IOException ex) {
                Logger.getLogger(ReplaceFileContentAction.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void setCatalog(@Nullable XBACatalog catalog) {
        this.catalog = catalog;
    }
}

