/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.file.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;
import org.exbin.framework.xbup.catalog.item.gui.RenamePanel;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBEXFile;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCXFile;

@ParametersAreNonnullByDefault
public class RenameFileAction
extends AbstractAction {
    public static final String ACTION_ID = "renameCatalogItemFileAction";
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(RenameFileAction.class);
    private XBApplication application;
    private XBACatalog catalog;
    private Component parentComponent;
    private XBCXFile currentFile;
    private String resultName;

    public void setup(XBApplication application) {
        this.application = application;
    }

    @Nullable
    public XBCXFile getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(XBCXFile currentFile) {
        this.currentFile = currentFile;
    }

    @Nullable
    public String getResultName() {
        return this.resultName;
    }

    public void setParentComponent(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    @Override
    public void actionPerformed(@Nullable ActionEvent event) {
        this.resultName = null;
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        RenamePanel renamePanel = new RenamePanel();
        renamePanel.setNameText(this.currentFile.getFilename());
        DefaultControlPanel controlPanel = new DefaultControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)renamePanel, (JPanel)controlPanel);
        controlPanel.setHandler(actionType -> {
            if (actionType == DefaultControlHandler.ControlActionType.OK) {
                String fileName = renamePanel.getNameText();
                ((XBEXFile)this.currentFile).setFilename(fileName);
                EntityManager em = ((XBECatalog)this.catalog).getEntityManager();
                EntityTransaction transaction = em.getTransaction();
                transaction.begin();
                em.persist((Object)this.currentFile);
                em.flush();
                transaction.commit();
                this.resultName = fileName;
            }
            dialog.close();
        });
        frameModule.setDialogTitle(dialog, this.resourceBundle);
        dialog.showCentered(this.parentComponent);
        dialog.dispose();
    }

    public void setCatalog(@Nullable XBACatalog catalog) {
        this.catalog = catalog;
    }
}

