/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.xbup.catalog.YamlFileType;
import org.exbin.xbup.catalog.convert.XBCatalogYaml;
import org.exbin.xbup.catalog.entity.XBENode;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCNode;

@ParametersAreNonnullByDefault
public class ImportItemAction
extends AbstractAction {
    public static final String ACTION_ID = "importItemAction";
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ImportItemAction.class);
    private XBApplication application;
    private XBACatalog catalog;
    private final XBCatalogYaml catalogYaml = new XBCatalogYaml();
    private Component parentComponent;
    private XBCItem currentItem;

    public void setup(XBApplication application, XBACatalog catalog) {
        this.application = application;
        this.catalog = catalog;
        ActionUtils.setupAction((Action)this, (ResourceBundle)this.resourceBundle, (String)ACTION_ID);
        this.putValue("dialogMode", true);
    }

    @Nullable
    public XBCItem getCurrentItem() {
        return this.currentItem;
    }

    public void setCurrentItem(@Nullable XBCItem currentItem) {
        this.currentItem = currentItem;
    }

    public void setParentComponent(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.currentItem != null && this.currentItem instanceof XBCNode) {
            JFileChooser importFileChooser = new JFileChooser();
            importFileChooser.addChoosableFileFilter(new YamlFileType());
            importFileChooser.setAcceptAllFileFilterUsed(true);
            if (importFileChooser.showOpenDialog(this.parentComponent) == 0) {
                try (FileInputStream fileStream = new FileInputStream(importFileChooser.getSelectedFile().getAbsolutePath());){
                    this.catalogYaml.importCatalogItem((InputStream)fileStream, (XBENode)this.currentItem);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException ex) {
                    Logger.getLogger(ImportItemAction.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalogYaml.setCatalog(catalog);
    }
}

