/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.xbup.catalog.item.gui.CatalogAddItemPanel;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBENode;
import org.exbin.xbup.catalog.entity.XBESpec;
import org.exbin.xbup.catalog.entity.service.XBEXNameService;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCBase;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.service.XBCNodeService;
import org.exbin.xbup.core.catalog.base.service.XBCRevService;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;

@ParametersAreNonnullByDefault
public class AddCatalogItemAction
extends AbstractAction {
    public static final String ACTION_ID = "addCatalogItemAction";
    private XBApplication application;
    private XBACatalog catalog;
    private XBCNodeService nodeService;
    private XBCSpecService specService;
    private XBCRevService revService;
    private XBCXNameService nameService;
    private Component parentComponent;
    private XBCItem currentItem;
    private XBCItem resultItem;

    public void setup(XBApplication application) {
        this.application = application;
    }

    @Nullable
    public XBCItem getCurrentItem() {
        return this.currentItem;
    }

    public void setCurrentItem(@Nullable XBCItem currentItem) {
        this.currentItem = currentItem;
    }

    @Nullable
    public XBCItem getResultItem() {
        return this.resultItem;
    }

    public void setParentComponent(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    @Override
    public void actionPerformed(@Nullable ActionEvent event) {
        this.resultItem = null;
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        CatalogAddItemPanel panel = new CatalogAddItemPanel();
        DefaultControlPanel controlPanel = new DefaultControlPanel();
        JPanel dialogPanel = WindowUtils.createDialogPanel((JComponent)panel, (JPanel)controlPanel);
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)dialogPanel);
        frameModule.setDialogTitle(dialog, panel.getResourceBundle());
        controlPanel.setHandler(actionType -> {
            switch (actionType) {
                case OK: {
                    EntityManager em = ((XBECatalog)this.catalog).getEntityManager();
                    EntityTransaction transaction = em.getTransaction();
                    transaction.begin();
                    XBENode node = (XBENode)(this.currentItem instanceof XBCNode ? this.currentItem : (XBCItem)this.currentItem.getParentItem().orElse(null));
                    XBENode item = null;
                    switch (panel.getItemType()) {
                        case NODE: {
                            item = (XBENode)this.nodeService.createItem();
                            Long newXbIndex = this.nodeService.findMaxSubNodeXB((XBCNode)node);
                            item.setXBIndex(newXbIndex == null ? 0L : newXbIndex + 1L);
                            break;
                        }
                        case BLOCK: {
                            item = (XBESpec)this.specService.createBlockSpec();
                            Long newXbIndex = this.specService.findMaxBlockSpecXB((XBCNode)node);
                            item.setXBIndex(newXbIndex == null ? 0L : newXbIndex + 1L);
                            break;
                        }
                        case GROUP: {
                            item = (XBESpec)this.specService.createGroupSpec();
                            Long newXbIndex = this.specService.findMaxBlockSpecXB((XBCNode)node);
                            item.setXBIndex(newXbIndex == null ? 0L : newXbIndex + 1L);
                            break;
                        }
                        case FORMAT: {
                            item = (XBESpec)this.specService.createFormatSpec();
                            Long newXbIndex = this.specService.findMaxBlockSpecXB((XBCNode)node);
                            item.setXBIndex(newXbIndex == null ? 0L : newXbIndex + 1L);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    if (item == null) {
                        throw new IllegalStateException();
                    }
                    item.setParentItem((XBCItem)node);
                    if (item instanceof XBCNode) {
                        this.nodeService.persistItem((XBCBase)((XBCNode)item));
                    } else {
                        this.specService.persistItem((XBCBase)((XBCSpec)item));
                    }
                    ((XBEXNameService)this.nameService).setDefaultText((XBCItem)item, panel.getItemName());
                    em.flush();
                    transaction.commit();
                    this.resultItem = item;
                    break;
                }
                case CANCEL: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected action type " + actionType.name());
                }
            }
            dialog.close();
        });
        dialog.showCentered(this.parentComponent);
        dialog.dispose();
    }

    public void setCatalog(@Nullable XBACatalog catalog) {
        this.catalog = catalog;
        this.nodeService = catalog == null ? null : (XBCNodeService)catalog.getCatalogService(XBCNodeService.class);
        this.specService = catalog == null ? null : (XBCSpecService)catalog.getCatalogService(XBCSpecService.class);
        this.revService = catalog == null ? null : (XBCRevService)catalog.getCatalogService(XBCRevService.class);
        this.nameService = catalog == null ? null : (XBCXNameService)catalog.getCatalogService(XBCXNameService.class);
    }
}

