/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.operation;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBTEditableDocument;
import org.exbin.xbup.operation.OperationEvent;
import org.exbin.xbup.operation.OperationListener;
import org.exbin.xbup.operation.XBTDocCommand;
import org.exbin.xbup.operation.XBTDocOperation;

@ParametersAreNonnullByDefault
public abstract class XBTOpDocCommand
extends XBTDocCommand {
    @Nullable
    private XBTDocOperation operation;
    private boolean isUndoMode = false;

    public XBTOpDocCommand(XBTEditableDocument document) {
        super(document);
    }

    @Nonnull
    public Optional<XBTDocOperation> getOperation() {
        return Optional.ofNullable(this.operation);
    }

    public void setOperation(@Nullable XBTDocOperation operation) {
        this.operation = operation;
    }

    @Nonnull
    public Optional<XBTDocOperation> getCurrentOperation() {
        return Optional.ofNullable(this.operation);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() throws Exception {
        XBTDocOperation redoOperation;
        if (this.isUndoMode) {
            redoOperation = this.operation.executeWithUndo().orElse(null);
            if (this.document instanceof OperationListener) {
                ((OperationListener)this.document).notifyChange(new OperationEvent(this.operation));
            }
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.operation = redoOperation;
        this.isUndoMode = false;
    }

    @Override
    public void redo() throws Exception {
        XBTDocOperation undoOperation;
        if (!this.isUndoMode) {
            undoOperation = this.operation.executeWithUndo().orElse(null);
            if (this.document instanceof OperationListener) {
                ((OperationListener)this.document).notifyChange(new OperationEvent(this.operation));
            }
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.operation = undoOperation;
        this.isUndoMode = true;
    }
}

