/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.preferences;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.basic.EnterKeyHandlingMode;
import org.exbin.bined.basic.TabKeyHandlingMode;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.bined.FileHandlingMode;
import org.exbin.framework.bined.options.EditorOptions;

@ParametersAreNonnullByDefault
public class EditorPreferences
implements EditorOptions {
    public static final String PREFERENCES_FILE_HANDLING_MODE = "fileHandlingMode";
    public static final String PREFERENCES_ENTER_KEY_HANDLING_MODE = "enterKeyHandlingMode";
    public static final String PREFERENCES_TAB_KEY_HANDLING_MODE = "tabKeyHandlingMode";
    private final Preferences preferences;

    public EditorPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Override
    @Nonnull
    public FileHandlingMode getFileHandlingMode() {
        FileHandlingMode defaultFileHandlingMode = FileHandlingMode.DELTA;
        try {
            return FileHandlingMode.valueOf(this.preferences.get(PREFERENCES_FILE_HANDLING_MODE, defaultFileHandlingMode.name()));
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(EditorPreferences.class.getName()).log(Level.SEVERE, null, ex);
            return defaultFileHandlingMode;
        }
    }

    @Override
    public void setFileHandlingMode(FileHandlingMode fileHandlingMode) {
        this.preferences.put(PREFERENCES_FILE_HANDLING_MODE, fileHandlingMode.name());
    }

    @Override
    @Nonnull
    public EnterKeyHandlingMode getEnterKeyHandlingMode() {
        EnterKeyHandlingMode defaultValue = EnterKeyHandlingMode.PLATFORM_SPECIFIC;
        try {
            return EnterKeyHandlingMode.valueOf((String)this.preferences.get(PREFERENCES_ENTER_KEY_HANDLING_MODE, defaultValue.name()));
        }
        catch (IllegalArgumentException ex) {
            return defaultValue;
        }
    }

    @Override
    public void setEnterKeyHandlingMode(EnterKeyHandlingMode enterKeyHandlingMode) {
        this.preferences.put(PREFERENCES_ENTER_KEY_HANDLING_MODE, enterKeyHandlingMode.name());
    }

    @Override
    @Nonnull
    public TabKeyHandlingMode getTabKeyHandlingMode() {
        TabKeyHandlingMode defaultValue = TabKeyHandlingMode.PLATFORM_SPECIFIC;
        try {
            return TabKeyHandlingMode.valueOf((String)this.preferences.get(PREFERENCES_TAB_KEY_HANDLING_MODE, defaultValue.name()));
        }
        catch (IllegalArgumentException ex) {
            return defaultValue;
        }
    }

    @Override
    public void setTabKeyHandlingMode(TabKeyHandlingMode tabKeyHandlingMode) {
        this.preferences.put(PREFERENCES_TAB_KEY_HANDLING_MODE, tabKeyHandlingMode.name());
    }
}

