/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.options.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.exbin.bined.swing.extended.theme.ExtendedCodeAreaThemeProfile;
import org.exbin.framework.bined.options.CodeAreaThemeOptions;
import org.exbin.framework.bined.preferences.CodeAreaThemePreferences;
import org.exbin.framework.options.api.OptionsData;

@ParametersAreNonnullByDefault
public class CodeAreaThemeOptionsImpl
implements OptionsData,
CodeAreaThemeOptions {
    private CodeAreaThemePreferences preferences;
    private final List<ProfileRecord> profileRecords = new ArrayList<ProfileRecord>();
    private int selectedProfile = -1;

    @Nonnull
    public List<String> getProfileNames() {
        ArrayList<String> profilesNames = new ArrayList<String>();
        this.profileRecords.forEach(profile -> profilesNames.add(profile.getName()));
        return profilesNames;
    }

    @Override
    @Nonnull
    public ExtendedCodeAreaThemeProfile getThemeProfile(int index) {
        ProfileRecord record = this.profileRecords.get(index);
        if (record.profile == null) {
            record = new ProfileRecord(record.name, this.preferences.getThemeProfile(index));
            this.profileRecords.set(index, record);
        }
        return record.profile;
    }

    @Override
    public void setThemeProfile(int index, ExtendedCodeAreaThemeProfile themeProfile) {
        ProfileRecord record = this.profileRecords.get(index);
        record = new ProfileRecord(record.name, themeProfile);
        this.profileRecords.set(index, record);
    }

    @Override
    public void removeThemeProfile(int index) {
        for (int i = index + 1; i < this.profileRecords.size(); ++i) {
            ProfileRecord record = this.profileRecords.get(i);
            if (record.profile != null) continue;
            record = new ProfileRecord(record.name, this.preferences.getThemeProfile(i));
            this.profileRecords.set(i, record);
        }
        if (this.selectedProfile == index) {
            this.selectedProfile = -1;
        } else if (this.selectedProfile > index) {
            --this.selectedProfile;
        }
        this.profileRecords.remove(index);
    }

    public void fullyLoad() {
        for (int i = 0; i < this.profileRecords.size(); ++i) {
            ProfileRecord record = this.profileRecords.get(i);
            if (record.profile != null) continue;
            record = new ProfileRecord(record.name, this.preferences.getThemeProfile(i));
            this.profileRecords.set(i, record);
        }
    }

    @Override
    public int getSelectedProfile() {
        return this.selectedProfile;
    }

    @Override
    public void setSelectedProfile(int profileIndex) {
        this.selectedProfile = profileIndex;
    }

    public void clearProfiles() {
        this.profileRecords.clear();
    }

    public void addProfile(String profileName, ExtendedCodeAreaThemeProfile themeProfile) {
        this.profileRecords.add(new ProfileRecord(profileName, themeProfile));
    }

    public void loadFromPreferences(CodeAreaThemePreferences preferences) {
        this.preferences = preferences;
        this.profileRecords.clear();
        List<String> themeProfilesList = preferences.getThemeProfilesList();
        themeProfilesList.forEach(name -> this.profileRecords.add(new ProfileRecord((String)name, null)));
        this.selectedProfile = preferences.getSelectedProfile();
    }

    public void saveToPreferences(CodeAreaThemePreferences preferences) {
        preferences.setSelectedProfile(this.selectedProfile);
        preferences.setThemeProfilesList(this.getProfileNames());
        for (int i = 0; i < this.profileRecords.size(); ++i) {
            ProfileRecord record = this.profileRecords.get(i);
            ExtendedCodeAreaThemeProfile profile = record.profile;
            if (profile == null) continue;
            preferences.setThemeProfile(i, record.profile);
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static class ProfileRecord {
        private final String name;
        private final ExtendedCodeAreaThemeProfile profile;

        public ProfileRecord(String name, ExtendedCodeAreaThemeProfile profile) {
            this.name = name;
            this.profile = profile;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nonnull
        public ExtendedCodeAreaThemeProfile getProfile() {
            return this.profile;
        }
    }
}

