/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.options.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.ByteArrayEditableData;
import org.exbin.bined.EditMode;
import org.exbin.bined.RowWrappingMode;
import org.exbin.bined.SelectionRange;
import org.exbin.bined.highlight.swing.extended.ExtendedHighlightCodeAreaPainter;
import org.exbin.bined.highlight.swing.extended.ExtendedHighlightNonAsciiCodeAreaPainter;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.bined.swing.CodeAreaPainter;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class PreviewPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(PreviewPanel.class);
    private ExtCodeArea codeArea;
    private final PreviewType previewType;
    private JLabel previewLabel;

    public PreviewPanel() {
        this(PreviewType.DEFAULT);
    }

    public PreviewPanel(PreviewType previewType) {
        this.previewType = previewType;
        this.initComponents();
        this.init();
    }

    @Nonnull
    public ExtCodeArea getCodeArea() {
        return this.codeArea;
    }

    private void init() {
        this.codeArea = new ExtCodeArea();
        this.codeArea.setFocusTraversalKeysEnabled(false);
        this.initPreviewCodeArea();
        this.add((Component)this.codeArea, "Center");
    }

    private void initPreviewCodeArea() {
        this.codeArea.setEditMode(EditMode.READ_ONLY);
        if (this.previewType == PreviewType.WITH_SEARCH) {
            ExtendedHighlightNonAsciiCodeAreaPainter painter = new ExtendedHighlightNonAsciiCodeAreaPainter((CodeAreaCore)this.codeArea);
            this.codeArea.setPainter((CodeAreaPainter)painter);
            ArrayList<ExtendedHighlightCodeAreaPainter.SearchMatch> exampleMatches = new ArrayList<ExtendedHighlightCodeAreaPainter.SearchMatch>();
            exampleMatches.add(new ExtendedHighlightCodeAreaPainter.SearchMatch(145L, 6L));
            exampleMatches.add(new ExtendedHighlightCodeAreaPainter.SearchMatch(480L, 6L));
            exampleMatches.add(new ExtendedHighlightCodeAreaPainter.SearchMatch(1983L, 6L));
            painter.setMatches(exampleMatches);
            painter.setCurrentMatchIndex(1);
        }
        ByteArrayEditableData exampleData = new ByteArrayEditableData();
        try {
            exampleData.loadFromStream(this.getClass().getResourceAsStream("/org/exbin/framework/bined/resources/preview/lorem.txt"));
        }
        catch (IOException ex) {
            Logger.getLogger(PreviewPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.codeArea.setContentData((BinaryData)exampleData);
        this.codeArea.setRowWrapping(RowWrappingMode.WRAPPING);
        this.codeArea.setEnabled(false);
        this.codeArea.setShowUnprintables(true);
        this.codeArea.setSelection(new SelectionRange(200L, 300L));
    }

    private void initComponents() {
        this.previewLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.previewLabel.setBackground(UIManager.getDefaults().getColor("Button.darkShadow"));
        this.previewLabel.setText(this.resourceBundle.getString("previewLabel.text"));
        this.previewLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.previewLabel.setOpaque(true);
        this.add((Component)this.previewLabel, "North");
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new PreviewPanel());
    }

    public static enum PreviewType {
        DEFAULT,
        WITH_SEARCH;

    }
}

