/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.action;

import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.BinEdFileHandler;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.file.api.FileDependentAction;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.utils.ActionUtils;

@ParametersAreNonnullByDefault
public class ReloadFileAction
extends AbstractAction
implements FileDependentAction {
    public static final String ACTION_ID = "reloadFileAction";
    private EditorProvider editorProvider;
    private XBApplication application;
    private ResourceBundle resourceBundle;

    public void setup(XBApplication application, EditorProvider editorProvider, ResourceBundle resourceBundle) {
        this.application = application;
        this.editorProvider = editorProvider;
        this.resourceBundle = resourceBundle;
        ActionUtils.setupAction((Action)this, (ResourceBundle)resourceBundle, (String)ACTION_ID);
    }

    public void updateForActiveFile() {
        Optional activeFile = this.editorProvider.getActiveFile();
        boolean canBeReloaded = activeFile.isPresent();
        if (canBeReloaded) {
            BinEdFileHandler fileHandler = (BinEdFileHandler)activeFile.get();
            canBeReloaded = fileHandler.getFileUri().isPresent();
        }
        this.setEnabled(canBeReloaded);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BinEdFileHandler fileHandler;
        Optional optActiveFile = this.editorProvider.getActiveFile();
        if (optActiveFile.isPresent() && this.editorProvider.releaseFile((FileHandler)(fileHandler = (BinEdFileHandler)optActiveFile.get())) && fileHandler.getFileUri().isPresent()) {
            fileHandler.reloadFile();
        }
    }
}

