/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.delta.DeltaDocument;
import org.exbin.bined.CodeAreaCaretPosition;
import org.exbin.bined.EditMode;
import org.exbin.bined.SelectionRange;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.framework.action.api.ActionModuleApi;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.BinEdEditorProvider;
import org.exbin.framework.bined.BinEdFileHandler;
import org.exbin.framework.bined.BinaryStatusApi;
import org.exbin.framework.bined.BinedModule;
import org.exbin.framework.bined.gui.BinEdComponentPanel;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.text.TextEncodingStatusApi;
import org.exbin.framework.file.api.AllFileTypes;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.file.api.FileLoading;
import org.exbin.framework.file.api.FileModuleApi;
import org.exbin.framework.file.api.FileType;
import org.exbin.framework.file.api.FileTypes;
import org.exbin.framework.file.api.UsedDirectoryApi;
import org.exbin.framework.operation.undo.api.UndoFileHandler;
import org.exbin.framework.utils.ClipboardActionsUpdater;
import org.exbin.xbup.operation.undo.XBUndoHandler;

@ParametersAreNonnullByDefault
public class BinaryEditorProvider
implements EditorProvider,
BinEdEditorProvider,
UndoFileHandler {
    private XBApplication application;
    private BinEdFileHandler activeFile;
    private FileTypes fileTypes;
    @Nullable
    private File lastUsedDirectory;
    private BinaryStatusApi binaryStatus;
    private EditorProvider.EditorModificationListener editorModificationListener;

    public BinaryEditorProvider(XBApplication application, BinEdFileHandler activeFile) {
        this.init(application, activeFile);
    }

    private void init(XBApplication application, BinEdFileHandler activeFile) {
        this.application = application;
        this.activeFile = activeFile;
        this.fileTypes = new AllFileTypes();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.addFlavorListener(e -> this.updateClipboardActionsStatus());
        activeFile.getComponent().setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent event) {
                try {
                    event.acceptDrop(1);
                    List droppedFiles = (List)event.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    Iterator iterator = droppedFiles.iterator();
                    if (iterator.hasNext()) {
                        Object file = iterator.next();
                        BinaryEditorProvider.this.openFile(((File)file).toURI(), null);
                    }
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    Logger.getLogger(BinaryEditorProvider.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    @Nonnull
    public Optional<FileHandler> getActiveFile() {
        return Optional.ofNullable(this.activeFile);
    }

    @Nonnull
    public BinEdComponentPanel getEditorComponent() {
        return this.activeFile.getComponent();
    }

    public void setModificationListener(EditorProvider.EditorModificationListener editorModificationListener) {
        this.editorModificationListener = editorModificationListener;
    }

    @Nonnull
    public String getWindowTitle(String parentTitle) {
        return this.activeFile.getWindowTitle(parentTitle);
    }

    @Override
    public void registerBinaryStatus(BinaryStatusApi binaryStatus) {
        this.binaryStatus = binaryStatus;
        ExtCodeArea codeArea = this.getEditorComponent().getCodeArea();
        codeArea.addDataChangedListener(() -> {
            this.activeFile.getComponent().notifyDataChanged();
            if (this.editorModificationListener != null) {
                this.editorModificationListener.modified();
            }
            this.updateCurrentDocumentSize();
        });
        codeArea.addSelectionChangedListener(() -> {
            binaryStatus.setSelectionRange(codeArea.getSelection());
            this.updateClipboardActionsStatus();
        });
        codeArea.addCaretMovedListener(caretPosition -> binaryStatus.setCursorPosition(caretPosition));
        codeArea.addEditModeChangedListener((mode, operation) -> binaryStatus.setEditMode(mode, operation));
        this.updateStatus();
    }

    @Override
    public void updateStatus() {
        this.updateCurrentDocumentSize();
        this.updateCurrentCaretPosition();
        this.updateCurrentSelectionRange();
        this.updateCurrentMemoryMode();
        this.updateCurrentEditMode();
    }

    private void updateCurrentDocumentSize() {
        if (this.binaryStatus == null) {
            return;
        }
        ExtCodeArea codeArea = this.activeFile.getCodeArea();
        long documentOriginalSize = this.activeFile.getDocumentOriginalSize();
        long dataSize = codeArea.getDataSize();
        this.binaryStatus.setCurrentDocumentSize(dataSize, documentOriginalSize);
    }

    private void updateCurrentCaretPosition() {
        if (this.binaryStatus == null) {
            return;
        }
        ExtCodeArea codeArea = this.activeFile.getCodeArea();
        CodeAreaCaretPosition caretPosition = codeArea.getCaretPosition();
        this.binaryStatus.setCursorPosition(caretPosition);
    }

    private void updateCurrentSelectionRange() {
        if (this.binaryStatus == null) {
            return;
        }
        ExtCodeArea codeArea = this.activeFile.getCodeArea();
        SelectionRange selectionRange = codeArea.getSelection();
        this.binaryStatus.setSelectionRange(selectionRange);
    }

    private void updateCurrentMemoryMode() {
        if (this.binaryStatus == null) {
            return;
        }
        ExtCodeArea codeArea = this.activeFile.getCodeArea();
        BinaryStatusApi.MemoryMode newMemoryMode = BinaryStatusApi.MemoryMode.RAM_MEMORY;
        if (codeArea.getEditMode() == EditMode.READ_ONLY) {
            newMemoryMode = BinaryStatusApi.MemoryMode.READ_ONLY;
        } else if (codeArea.getContentData() instanceof DeltaDocument) {
            newMemoryMode = BinaryStatusApi.MemoryMode.DELTA_MODE;
        }
        this.binaryStatus.setMemoryMode(newMemoryMode);
    }

    private void updateCurrentEditMode() {
        if (this.binaryStatus == null) {
            return;
        }
        ExtCodeArea codeArea = this.activeFile.getCodeArea();
        this.binaryStatus.setEditMode(codeArea.getEditMode(), codeArea.getActiveOperation());
    }

    @Override
    public void registerEncodingStatus(TextEncodingStatusApi encodingStatus) {
        encodingStatus.setEncoding(this.activeFile.getCharset().name());
    }

    public void newFile() {
        if (this.releaseAllFiles()) {
            this.activeFile.clearFile();
            BinedModule binedModule = (BinedModule)this.application.getModuleRepository().getModuleByInterface(BinedModule.class);
            String title = binedModule.getNewFileTitlePrefix() + " " + this.activeFile.getId();
            this.activeFile.setTitle(title);
        }
    }

    public void openFile(URI fileUri, @Nullable FileType fileType) {
        this.activeFile.loadFromFile(fileUri, fileType);
    }

    public void openFile() {
        if (this.releaseAllFiles()) {
            FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
            fileModule.getFileActions().openFile((FileLoading)this.activeFile, this.fileTypes, (UsedDirectoryApi)this);
        }
    }

    public void loadFromFile(String fileName) throws URISyntaxException {
        URI fileUri = new URI(fileName);
        this.activeFile.loadFromFile(fileUri, null);
    }

    public void loadFromFile(URI fileUri, @Nullable FileType fileType) {
        this.activeFile.loadFromFile(fileUri, fileType);
    }

    public boolean canSave() {
        return this.activeFile.isSaveSupported() && this.activeFile.isEditable();
    }

    public void saveFile() {
        if (this.activeFile.getFileUri().isPresent()) {
            this.activeFile.saveFile();
        } else {
            this.saveAsFile();
        }
    }

    public void saveAsFile() {
        FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
        fileModule.getFileActions().saveAsFile((FileHandler)this.activeFile, this.fileTypes, (UsedDirectoryApi)this);
    }

    public boolean releaseFile(FileHandler fileHandler) {
        if (fileHandler.isModified()) {
            FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
            return fileModule.getFileActions().showAskForSaveDialog(fileHandler, this.fileTypes, (UsedDirectoryApi)this);
        }
        return true;
    }

    public boolean releaseAllFiles() {
        return this.releaseFile(this.activeFile);
    }

    @Nonnull
    public XBUndoHandler getUndoHandler() {
        return this.activeFile.getUndoHandler();
    }

    @Nonnull
    public Optional<File> getLastUsedDirectory() {
        return Optional.ofNullable(this.lastUsedDirectory);
    }

    public void setLastUsedDirectory(@Nullable File directory) {
        this.lastUsedDirectory = directory;
    }

    public void updateRecentFilesList(URI fileUri, FileType fileType) {
        FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
        fileModule.updateRecentFilesList(fileUri, fileType);
    }

    private void updateClipboardActionsStatus() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        ((ClipboardActionsUpdater)actionModule.getClipboardActions()).updateClipboardActions();
    }
}

