/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.bined.extended.layout.ExtendedCodeAreaLayoutProfile;
import org.exbin.bined.operation.swing.CodeAreaOperationCommandHandler;
import org.exbin.bined.operation.undo.BinaryDataUndoHandler;
import org.exbin.bined.swing.basic.color.CodeAreaColorsProfile;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.bined.swing.extended.theme.ExtendedCodeAreaThemeProfile;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.gui.BinEdComponentPanel;
import org.exbin.framework.bined.options.impl.CodeAreaOptionsImpl;
import org.exbin.framework.bined.preferences.BinaryEditorPreferences;
import org.exbin.framework.bined.preferences.CodeAreaColorPreferences;
import org.exbin.framework.bined.preferences.CodeAreaLayoutPreferences;
import org.exbin.framework.bined.preferences.CodeAreaThemePreferences;
import org.exbin.framework.bined.preferences.EditorPreferences;

@ParametersAreNonnullByDefault
public class BinEdEditorComponent {
    private final ExtendedCodeAreaLayoutProfile defaultLayoutProfile;
    private final ExtendedCodeAreaThemeProfile defaultThemeProfile;
    private final CodeAreaColorsProfile defaultColorProfile;
    private BinEdComponentPanel componentPanel = new BinEdComponentPanel();

    public BinEdEditorComponent() {
        ExtCodeArea codeArea = this.componentPanel.getCodeArea();
        this.defaultLayoutProfile = codeArea.getLayoutProfile();
        this.defaultThemeProfile = codeArea.getThemeProfile();
        this.defaultColorProfile = codeArea.getColorsProfile();
    }

    public void setApplication(XBApplication application) {
    }

    @Nonnull
    public BinEdComponentPanel getComponentPanel() {
        return this.componentPanel;
    }

    @Nonnull
    public ExtCodeArea getCodeArea() {
        return this.componentPanel.getCodeArea();
    }

    @Nonnull
    public Optional<BinaryDataUndoHandler> getUndoHandler() {
        return this.componentPanel.getUndoHandler();
    }

    public void setUndoHandler(BinaryDataUndoHandler undoHandler) {
        this.componentPanel.setUndoHandler(undoHandler);
    }

    public void onInitFromPreferences(BinaryEditorPreferences preferences) {
        this.componentPanel.onInitFromPreferences(preferences);
        ExtCodeArea codeArea = this.componentPanel.getCodeArea();
        CodeAreaOptionsImpl.applyToCodeArea(preferences.getCodeAreaPreferences(), codeArea);
        EditorPreferences editorOptions = preferences.getEditorPreferences();
        if (codeArea.getCommandHandler() instanceof CodeAreaOperationCommandHandler) {
            ((CodeAreaOperationCommandHandler)codeArea.getCommandHandler()).setEnterKeyHandlingMode(editorOptions.getEnterKeyHandlingMode());
            ((CodeAreaOperationCommandHandler)codeArea.getCommandHandler()).setTabKeyHandlingMode(editorOptions.getTabKeyHandlingMode());
        }
        this.applyProfileFromPreferences(preferences);
    }

    public void applyProfileFromPreferences(BinaryEditorPreferences preferences) {
        ExtCodeArea codeArea = this.componentPanel.getCodeArea();
        CodeAreaLayoutPreferences layoutOptions = preferences.getLayoutPreferences();
        int selectedLayoutProfile = layoutOptions.getSelectedProfile();
        if (selectedLayoutProfile >= 0) {
            codeArea.setLayoutProfile((ExtendedCodeAreaLayoutProfile)layoutOptions.getLayoutProfile(selectedLayoutProfile));
        } else {
            codeArea.setLayoutProfile(this.defaultLayoutProfile);
        }
        CodeAreaThemePreferences themeOptions = preferences.getThemePreferences();
        int selectedThemeProfile = themeOptions.getSelectedProfile();
        if (selectedThemeProfile >= 0) {
            codeArea.setThemeProfile(themeOptions.getThemeProfile(selectedThemeProfile));
        } else {
            codeArea.setThemeProfile(this.defaultThemeProfile);
        }
        CodeAreaColorPreferences colorOptions = preferences.getColorPreferences();
        int selectedColorProfile = colorOptions.getSelectedProfile();
        if (selectedColorProfile >= 0) {
            codeArea.setColorsProfile((CodeAreaColorsProfile)colorOptions.getColorsProfile(selectedColorProfile));
        } else {
            codeArea.setColorsProfile(this.defaultColorProfile);
        }
    }

    @Nonnull
    public BinaryData getContentData() {
        ExtCodeArea codeArea = this.componentPanel.getCodeArea();
        return codeArea.getContentData();
    }

    public void setContentData(@Nullable BinaryData data) {
        ExtCodeArea codeArea = this.componentPanel.getCodeArea();
        codeArea.setContentData(data);
    }
}

