/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.component.action;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.exbin.framework.component.ComponentModule;
import org.exbin.framework.component.api.toolbar.MoveItemActions;
import org.exbin.framework.component.api.toolbar.MoveItemActionsHandler;
import org.exbin.framework.component.api.toolbar.SideToolBar;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;

@ParametersAreNonnullByDefault
public class DefaultMoveItemActions
implements MoveItemActions {
    public static final String MOVE_ITEM_UP_ACTION_ID = "moveItemUpAction";
    public static final String MOVE_ITEM_DOWN_ACTION_ID = "moveItemDownAction";
    public static final String MOVE_ITEM_TOP_ACTION_ID = "moveItemTopAction";
    public static final String MOVE_ITEM_BOTTOM_ACTION_ID = "moveItemBottomAction";
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ComponentModule.class);
    private MoveItemActionsHandler actionsHandler = null;
    private Action moveUpAction = null;
    private Action moveDownAction = null;
    private Action moveTopAction = null;
    private Action moveBottomAction = null;

    public void setMoveItemActionsHandler(MoveItemActionsHandler actionsHandler) {
        this.actionsHandler = actionsHandler;
    }

    @Nonnull
    public Action getMoveUpAction() {
        if (this.moveUpAction == null) {
            this.moveUpAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultMoveItemActions.this.actionsHandler.performMoveUp();
                }
            };
            ActionUtils.setupAction((Action)this.moveUpAction, (ResourceBundle)this.resourceBundle, (String)MOVE_ITEM_UP_ACTION_ID);
            this.moveUpAction.setEnabled(false);
        }
        return this.moveUpAction;
    }

    @Nonnull
    public Action getMoveDownAction() {
        if (this.moveDownAction == null) {
            this.moveDownAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultMoveItemActions.this.actionsHandler.performMoveDown();
                }
            };
            ActionUtils.setupAction((Action)this.moveDownAction, (ResourceBundle)this.resourceBundle, (String)MOVE_ITEM_DOWN_ACTION_ID);
            this.moveDownAction.setEnabled(false);
        }
        return this.moveDownAction;
    }

    @Nonnull
    public Action getMoveTopAction() {
        if (this.moveTopAction == null) {
            this.moveTopAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultMoveItemActions.this.actionsHandler.performMoveTop();
                }
            };
            ActionUtils.setupAction((Action)this.moveTopAction, (ResourceBundle)this.resourceBundle, (String)MOVE_ITEM_TOP_ACTION_ID);
            this.moveTopAction.setEnabled(false);
        }
        return this.moveTopAction;
    }

    @Nonnull
    public Action getMoveBottomAction() {
        if (this.moveBottomAction == null) {
            this.moveBottomAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultMoveItemActions.this.actionsHandler.performMoveBottom();
                }
            };
            ActionUtils.setupAction((Action)this.moveBottomAction, (ResourceBundle)this.resourceBundle, (String)MOVE_ITEM_BOTTOM_ACTION_ID);
            this.moveBottomAction.setEnabled(false);
        }
        return this.moveBottomAction;
    }

    public void updateMoveItemActions() {
        boolean enabled;
        boolean bl = enabled = this.actionsHandler.isEditable() && this.actionsHandler.isSelection();
        if (this.moveUpAction != null) {
            this.moveUpAction.setEnabled(enabled);
        }
        if (this.moveDownAction != null) {
            this.moveDownAction.setEnabled(enabled);
        }
        if (this.moveTopAction != null) {
            this.moveTopAction.setEnabled(enabled);
        }
        if (this.moveBottomAction != null) {
            this.moveBottomAction.setEnabled(enabled);
        }
    }

    public void registerActions(SideToolBar sideToolBar) {
        sideToolBar.addAction(this.getMoveTopAction());
        sideToolBar.addAction(this.getMoveUpAction());
        sideToolBar.addAction(this.getMoveDownAction());
        sideToolBar.addAction(this.getMoveBottomAction());
        this.updateMoveItemActions();
        this.actionsHandler.setUpdateListener(this::updateMoveItemActions);
    }
}

