/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client.stub;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.client.XBCatalogServiceClient;
import org.exbin.xbup.client.stub.XBPBaseProcedureType;
import org.exbin.xbup.client.stub.XBPConstructorMethod;
import org.exbin.xbup.client.stub.XBPItemStub;
import org.exbin.xbup.client.stub.XBPManagerStub;
import org.exbin.xbup.client.stub.XBPStubUtils;
import org.exbin.xbup.core.catalog.base.XBCBase;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.remote.XBCallHandler;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;

@ParametersAreNonnullByDefault
public class XBPBaseStub<T extends XBCBase>
implements XBPManagerStub<T> {
    private final XBCatalogServiceClient client;
    private final XBPConstructorMethod<T> constructorMethod;
    private final XBPBaseProcedureType baseTypes;

    public XBPBaseStub(XBCatalogServiceClient client, XBPConstructorMethod<T> service, XBPBaseProcedureType baseTypes) {
        this.client = client;
        this.constructorMethod = service;
        this.baseTypes = baseTypes;
    }

    @Override
    @Nonnull
    public T constructItem(long itemId) {
        return this.constructorMethod.itemConstructor(this.client, itemId);
    }

    @Override
    @Nonnull
    public T createItem() {
        Long itemId = XBPStubUtils.voidToLongMethod(this.client.procedureCall(), this.baseTypes.getCreateItemType());
        return this.constructorMethod.itemConstructor(this.client, itemId);
    }

    @Override
    public void persistItem(XBCBase item) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeItem(XBCBase item) {
        XBPStubUtils.longToVoidMethod(this.client.procedureCall(), this.baseTypes.getRemoveItemType(), item.getId());
    }

    @Override
    @Nonnull
    public Optional<T> getItem(long itemId) {
        Long foundItemId = XBPStubUtils.longToLongMethod(this.client.procedureCall(), this.baseTypes.getItemByIdType(), itemId);
        return foundItemId == null ? Optional.empty() : Optional.of(this.constructorMethod.itemConstructor(this.client, foundItemId));
    }

    @Override
    @Nonnull
    public List<T> getAllItems() {
        ArrayList<T> result = new ArrayList<T>();
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType(this.baseTypes.getItemByIdType());
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            if (!serialOutput.pullIfEmptyBlock()) {
                serialOutput.begin();
                serialOutput.matchType();
                long count = serialOutput.pullLongAttribute();
                int i = 0;
                while ((long)i < count) {
                    result.add(this.constructItem(serialOutput.pullLongAttribute()));
                    ++i;
                }
                serialOutput.end();
                procedureCall.execute();
                return result;
            }
            procedureCall.execute();
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPItemStub.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    @Override
    public long getItemsCount() {
        return XBPStubUtils.voidToLongMethod(this.client.procedureCall(), this.baseTypes.getItemsCountType());
    }
}

